<?php

/**
 * Blob Storage 0.1 Alpha
 * 
 * Runs great on PHP 5.3.3 :)
 * 
 * @author RiderSx
 *
 */

class BlobException extends Exception {}

class Blob {
	private $_desc, $_index;
	private $_blobsize, $_dir;
	
	/**
	 * Constructor :)
	 * 
	 * @param string $directory
	 */
	public function __construct ($directory) {
		$this->_dir      = $directory;
		
		$this->_desc     = fopen       ($directory.'storage.blob', "rb+");
		$this->_index    = unserialize (file_get_contents($directory.'indexes.idx'));
		$this->_blobsize = filesize    ($directory.'storage.blob');
	}
	
	/**
	 * Writes data
	 * 
	 * @param binary_string $data
	 * @return string $id
	 */
	public function set ($data) {
		$this->_fseek($this->_blobsize);
		$this->_fwrite($data);
		
		$id                  = $this->_generateID();
		$size                = strlen($data);
		$this->_index[$id]   = array('start'=>$this->_blobsize, 'end'=>$this->_blobsize+$size);
		$this->_blobsize    += $size;
		
		return $id;
	}
	
	/**
	 * Returns data
	 * 
	 * @param string $id
	 * @return string
	 */
	public function get ($id) {
		$this->_fseek($this->_index[$id]['start']);
		return $this->_fread($this->_index[$id]['end']-$this->_index[$id]['start']);
	}
	
	/**
	 * Generates random id
	 * 
	 * @return string
	 */
	private function _generateID () {
		return md5(uniqid('blobby').crc32(uniqid('blobby'))).crc32(uniqid('blobby'));
	}
	
	/**
	 * Reads passed bytes from blob
	 * 
	 * @param int $bytes
	 */
	private function _fread ($bytes) {
		if($this->_desc) return fread($this->_desc, $bytes);
		else throw new BlobException('No file descriptor');
	}
	
	/**
	 * Replacing some basic functions
	 */
	private function _fwrite ($data) {
		if($this->_desc) return fwrite($this->_desc, $data, strlen($data));
		else throw new BlobException('No file descriptor');
	}
	
	private function _fseek ($byte) {
		if($this->_desc) return fseek($this->_desc, $byte);
		else throw new BlobException('No file descriptor');
	}
	
	private function _rewind () {
		if($this->_desc) return rewind($this->_desc);
		else throw new BlobException('No file descriptor');
	}
	
	public function __destruct () {
		fclose($this->_desc);
		file_put_contents($this->_dir.'indexes.idx', serialize($this->_index));
	}
}