<?php
######################################################################
# MiniForum: Minimum Functionality Forum
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: editprofile.php
# Version: 1.0
#####################################################################

if (!@$_SESSION['user_logged'])
	header ("Location: index.php?login=do");
	
if ($_SESSION['user_status'] == "0")
	$smarty->assign ("banned", true);
else	
{
	$smarty->assign ("welcome", $_SESSION['user_name']);
	$smarty->assign ("logout", true);
	
	$user = new user ($db, $_SESSION['user_id']);
	
	if (isset ($_POST['do_edit']))
	{
		$addkey = true;
		
		if (isset ($_POST['mail']))
		{
			$mail = $user->check_email ($_POST['mail']);
			if (!$mail)
			{
				$smarty->assign ("mail_error", true);
				$addkey = false;
			}
		}
		else
			$addkey = false;
		
		if (isset ($_POST['day']) && isset ($_POST['month']) && isset ($_POST['year']))
		{
			$birthday = $user->check_birthday ($_POST['day'], $_POST['month'], $_POST['year']);
			if (!$birthday)
			{
				$smarty->assign ("birthday_error", true);
				$addkey = false;
			}
		}
		else
			$birthday = NULL;
		
		if (isset ($_POST['icq']))
		{
			$icq = $user->check_icq ($_POST['icq']);
			if (!$icq)
			{
				$smarty->assign ("icq_error", true);
				$addkey = false;
			}
			else
			{
				if ($icq === true)
					$icq = NULL;
			}
		}
		else
			$icq = NULL;
		
		if ($addkey)
		{
			if ($user->edit ($mail, @$_POST['name'], @$_POST['sex'], $birthday, @$_POST['user_from'], $icq, @$_POST['about']))
				$smarty->assign ("editprofile_ok_page", true);
			else
				$smarty->assign ("tech_error", true);
		}
		else
		{
			$data = $user->get ();
			
			$smarty->assign ("user", $data);
			
			if ($data['birthday'] && $data['birthday'] != "0000-00-00")
			{
				$smarty->assign ("birthday", $date = explode ("-", $data['birthday']));
				$smarty->assign ("birthselect".$date[1], "selected");
			}
			
			$smarty->assign ("editprofile_error", true);
			$smarty->assign ("editprofile_page", true);
		}
	}
	elseif (isset ($_POST['ch_pass']))
	{
		$addkey = true;
		
		if (isset ($_POST['pass1']) && isset ($_POST['pass2']))
		{
			if ($_POST['pass1'] != $_POST['pass2'])
				$addkey = false;
			else
			{
				$pass = $user->check_password ($_POST['pass1']);
				if (!$pass)
					$addkey = false;
			}
		}
		else
			$addkey = false;
			
		if ($addkey)
		{
			if ($user->change_password ($pass))	
				$smarty->assign ("editprofile_ok_page", true);
			else
				$smarty->assign ("tech_error", true);
		}
		else
		{
			$data = $user->get ($db);
			
			$smarty->assign ("user", $data);
			
			if ($data['birthday'] && $data['birthday'] != "0000-00-00")
			{
				$smarty->assign ("birthday", $date = explode ("-", $data['birthday']));
				$smarty->assign ("birthselect".$date[1], "selected");
			}
			
			$smarty->assign ("password_error", true);
			$smarty->assign ("editprofile_page", true);
		}
	}
	else
	{
		$data = $user->get ();
		
		$smarty->assign ("user", $data);
		
		if ($data['birthday'] && $data['birthday'] != "0000-00-00")
		{
			$smarty->assign ("birthday", $date = explode ("-", $data['birthday']));
			$smarty->assign ("birthselect".$date[1], "selected");
		}
		
		$smarty->assign ("editprofile_page", true);
	}
}

?>