<?php
######################################################################
# MiniForum: Minimum Functionality Forum
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: admin.php
# Version: 1.0
#####################################################################

ini_set ("display_errors", 0);
ini_set ("session.use_trans_sid", false);

session_start();

require_once ("./config/connect.php");
require_once ("./config/tables.php");

require_once ("./smarty/smarty.class.php");
require_once ("./class/db.php");
require_once ("./class/theme.php");
require_once ("./class/post.php");
require_once ("./class/user.php");

$smarty = new Smarty;
$db = new db (_DB_HOST,_DB_USER,_DB_PASS,_DB_NAME);

require_once ("./includes/set_config.php");

require_once ("./includes/check_cookie.php");

require_once ("./includes/update_userdata.php");

require_once ("./includes/lang.php");

if (!@$_SESSION['user_logged'])
	header ("Location: index.php?login=do");
elseif ($_SESSION['user_status'] < 2)
	$smarty->assign ("access_denied", true);
else
{
	switch (@$_GET['in'])
	{
		case "settings": require_once ("./admin/settings.php");
		break;
		
		case "theme": require_once ("./admin/theme.php");
		break;
		
		case "post": require_once ("./admin/post.php");
		break;
		
		case "user": require_once ("./admin/user.php");
		break;
		
		default: $smarty->assign ("menu", true);
	}
}

$smarty->display ("admin/admin.tpl.html");

require_once ("./includes/javascript.php");

?>