<?php

Class Parser
{
	public static $url;
	public static $contents;
	
	public static function TryEncode()
	{
		preg_match("#charset=([^\"]*)#", self::$contents, $m);
		
		if (isset($m[1]) && !stristr($m[1], 'windows-1251')) {
			self::$contents = iconv(strtoupper($m[1]), 'CP1251', self::$contents);
		}
		else {
			preg_match("#charset=([^']*)#", self::$contents, $m);
			if (isset($m[1]) && !stristr($m[1], 'windows-1251')) {
				self::$contents = iconv(strtoupper($m[1]), 'CP1251', self::$contents);
			}
		}
	}

	public static function Images()
	{
		self::$contents = preg_replace("#<img[^>]+src=\"([^\"]+)\"[^>]*>#ies", "'<img src=\"'.self::ImageReMake('\\1').'\" border=\"0\" />'", self::$contents);
		self::$contents = preg_replace("#<img[^>]+src='([^']+)'[^>]*>#ies", "'<img src=\"'.self::ImageReMake('\\1').'\" border=\"0\" />'", self::$contents);
	}
	
	public static function CSS()
	{
		self::$contents = preg_replace("#<link[^>]+rel=\"stylesheet\"[^>]+href=\"([^\"]+)\"[^>]*>#ies", "'<link rel=\"stylesheet\" type=\"text/css\" href=\"'.self::CSSReMake('\\1').'\" />'", self::$contents);
		self::$contents = preg_replace("#<link[^>]+href=\"([^\"]+)\"[^>]+rel=\"stylesheet\"[^>]*>#ies", "'<link rel=\"stylesheet\" type=\"text/css\" href=\"'.self::CSSReMake('\\1').'\" />'", self::$contents);
		
		self::$contents = preg_replace("#<link[^>]+rel='stylesheet'[^>]+href='([^']+)'[^>]*>#ies", "'<link rel=\"stylesheet\" type=\"text/css\" href=\"'.self::CSSReMake('\\1').'\" />'", self::$contents);
		self::$contents = preg_replace("#<link[^>]+href='([^']+)'[^>]+rel='stylesheet'[^>]*>#ies", "'<link rel=\"stylesheet\" type=\"text/css\" href=\"'.self::CSSReMake('\\1').'\" />'", self::$contents);
	}
	
	public static function URLs()
	{
		self::$contents = preg_replace("#<a[^>]+href=\"([^\"]+)\"[^>]*>#ies", "'<a href=\"'.self::URLReMake('\\1').'\">'", self::$contents);
		self::$contents = preg_replace("#<a[^>]+href='([^']+)'[^>]*>#ies", "'<a href=\"'.self::URLReMake('\\1').'\">'", self::$contents);
	}
	
	private static function ImageReMake($url)
	{
		$result = '';
		
		$parse = parse_url($url);
		//print_r($parse);
		//print $url . ' -> ';
		
		if (isset($parse['scheme'])) {
			if ($parse['scheme']=='http') {
				$result = $url;
			}
			else {
				//print '<br /><br />';
				return(false);
			}
		}
		else {
			$result = self::uri2absolute($url, self::$url);
		}
		
		$result = 'image.php?url=' . urlencode($result);
		
		//print $result . '<br /><br />';
		
		return($result);
	}
	
	private static function CSSRemake($url)
	{
		$result = '';
		
		$parse = parse_url($url);
		//print_r($parse);
		//print $url . ' -> ';
		
		if (isset($parse['scheme'])) {
			if ($parse['scheme']=='http') {
				$result = $url;
			}
			else {
				//print '<br /><br />';
				return(false);
			}
		}
		else {
			$result = self::uri2absolute($url, self::$url);
		}
		
		$result = 'css.php?url=' . urlencode($result);
		
		//print $result . '<br /><br />';
		
		return($result);
	}
	
	private static function URLReMake($url)
	{
		$result = '';
		
		$parse = @parse_url($url);
		//print_r($parse);
		//print $url . ' -> ';
		
		if (isset($parse['scheme'])) {
			if ($parse['scheme']=='http') {
				$result = $url;
			}
			else {
				//print '<br /><br />';
				return(false);
			}
		}
		else {
			$result = self::uri2absolute($url, self::$url);
		}
		
		$result = 'content.php?url=' . urlencode($result);
		
		//print $result . '<br /><br />';
		
		return($result);
	}
	
	
	
	
	
	
	/**
	 *        html-
	 *
	 * @param  string $htmlCode  
	 * @param  string $url       
	 * @return string  
	 */
	public static function getBaseHref($htmlCode, $url)
	{
	    if (!preg_match('~<base\s+href\s*=\s*[\'"]?([^\'">]+).*?>~is', $htmlCode, $matches)) {
	        return $url;
	    }
	    return self::uri2absolute(htmlSpecialChars_decode($matches[1]), $url);
	}
	
	/**
	 *     URI
	 *
	 * @param  string $link  ( URI,    ,  )
	 * @param  string $base  URI (  "http://")
	 * @return string  URI 
	 */
	public static function uri2absolute($link, $base)
	{
	    if (!preg_match('~^(http://[^/?#]+)?([^?#]*)?(\?[^#]*)?(#.*)?$~i', $link.'#', $matchesLink)) { 
	        return false;
	    }    
	    if (!empty($matchesLink[1])) {
	        return $link;
	    }
	    if (!preg_match('~^(http://)?([^/?#]+)(/[^?#]*)?(\?[^#]*)?(#.*)?$~i', $base.'#', $matchesBase)) {
	        return false;
	    }
	    if (empty($matchesLink[2])) {
	        if (empty($matchesLink[3])) {
	            return 'http://'.$matchesBase[2].$matchesBase[3].$matchesBase[4];;
	        }
	        return 'http://'.$matchesBase[2].$matchesBase[3].$matchesLink[3];
	    }
	    $pathLink = explode('/', $matchesLink[2]);
	    if ($pathLink[0] == '') {
	        return 'http://'.$matchesBase[2].$matchesLink[2].$matchesLink[3];
	    }
	    $pathBase = explode('/', preg_replace('~^/~', '', $matchesBase[3]));
	    if (sizeOf($pathBase) > 0) {
	        array_pop($pathBase);
	    }
	    foreach ($pathLink as $p) {
	        if ($p == '.') {
	            continue;
	        } elseif ($p == '..') {
	            if (sizeOf($pathBase) > 0) {
	                array_pop($pathBase);                
	            }
	        } else {
	            array_push($pathBase, $p);            
	        }
	    }    
	    return 'http://'.$matchesBase[2].'/'.implode('/', $pathBase).$matchesLink[3];    
	}
}

?>