<?php

class Qb
{
	public static $baseUrl = 'http://test1.ru/myrouter';

	public static $config = array(
		'router' => array(
			'rules'=>array(
				'Post/List:1'	=> '/',
				'Post/List:2'	=> '/tag/(tag)',
				'Post/List:3'	=> '/posts',
				'Post/List:4'	=> '/posts/(date)',
				'Post/Show:1'	=> '/post/(id)',
				'Post/Show:1a'	=> '/post/(id)#r(rid)',
				'Post/Show:p'	=> '/posts/(id)/page-(p)',
				'Post/Show:pa'	=> '/posts/(id)/page-(p)#r(rid)',
				'Post/Update'	=> '/post/edit/(id)',
				'Comment/Add'	=> '/post/reply/(id)',
				'Comment/Update'=> '/reply/edit/(id)',
			),
			'vars' => array(
				'id'	=> '\d+',
				'rid'	=> '\d+',
				'p'		=> '\d+',
				'tag'	=> '.+',
				'date'	=> '\d{4}-\d{2}-\d{2}',
			),
			'translate' => array(
				'date' => array('_dateIn', '_dateOut'),
			)
		)
	);
}


class QbRouter
{
	public static function request()
	{
		$route = FALSE;

		$uri = $_SERVER['REQUEST_URI'];
		// skip base folder
		if ($p = strpos(Qb::$baseUrl, '/', 8))
			$uri = substr($uri, strlen(Qb::$baseUrl) - $p);

		self::_compileRules(); // TODO: cache it
		foreach (self::$_rules as $routeId => $r)
		{
			if (preg_match($r['pattern'], $uri, $matches))
			{
				$route['routeId'] = $routeId;
				$i = 0;
				foreach($r['vars'] as $id)
					$route[$id] = $matches[++$i];
				array_walk($route, array('self', '_varIn'));
				break;
			}
		}

		return $route;
	}

	public static function url($routeId, $vars = NULL)
	{
		$pattern = Qb::$config['router']['rules'][$routeId];
		if (!empty($vars))
		{
			array_walk($vars, array('self', '_varOut'));
			$pattern = str_replace(array_map(array('self', '_mapBrackets'), array_keys($vars)), array_values($vars), $pattern);
		}
		return Qb::$baseUrl.$pattern;
	}

	private static $_rules;

	private static function _compileRules()
	{
		self::$_rules = array();
		foreach(Qb::$config['router']['rules'] as $routeId => $pattern)
		{
			if (($p = strpos($pattern, '#')) !== FALSE)
				$pattern = substr($pattern, 0, $p);

	        $vars = array();
	        foreach(Qb::$config['router']['vars'] as $id => $reg)
	        {
	        	$idb = '('.$id.')';
	        	$regb = '('.$reg.')';
	            while(($p = strpos($pattern, $idb)) !== FALSE)
	            {
	                $pattern = str_replace($idb, $regb, $pattern);
	                $vars[$p] = $id;
	            }
	        }
	        ksort($vars);

	        self::$_rules[$routeId] = array(
	        	'pattern' => $pattern = '#^'.$pattern.'$#ism',
	        	'vars' => $vars);
        }
	}

	private static function _mapBrackets(&$s) {return '('.$s.')';}

	private static function _varIn(&$item, $key)
	{
		$varTypes =& Qb::$config['router']['translate'];
		if (isset($varTypes[$key]))
			$item = call_user_func($varTypes[$key][0], $item);
	}

	private static function _varOut(&$item, $key)
	{
		$varTypes =& Qb::$config['router']['translate'];
		if (isset($varTypes[$key]))
			$item = call_user_func($varTypes[$key][1], $item);
	}

}


function _dateIn($value)
{
	$parts = explode('-', $value);
	return gmmktime(0, 0, 0, $parts[1], $parts[2], $parts[0]);
}

function _dateOut($value)
{
	return date('Y-m-d', $value);
}

$r = QbRouter::request();
echo "<pre>\n";
echo $_SERVER['REQUEST_URI']."\n";
echo "\n";
echo ($r === FALSE) ? 'No route' : print_r($r, TRUE);
echo "\n";
echo '<a href="'.QbRouter::url('Post/List:4', array('date'=>time())).'">Link 1</a>'."\n";
echo '<a href="'.QbRouter::url('Post/Show:1a', array('id'=>15, 'rid'=>77)).'">Link 2</a>'."\n";
echo '<a href="'.QbRouter::url('Post/Show:pa', array('id'=>15, 'rid'=>77, 'p'=>2)).'">Link 3</a>'."\n";
echo '<a href="'.QbRouter::url('Post/List:2', array('tag'=>'framework')).'">Link 4</a>'."\n";
echo "</pre>\n";

?>