<?php
// Обрабатываются все возможные ошибки
error_reporting(-1);

// Стандартный вывод ошибок выключен
ini_set('display_errors', 0);


/******************************************************************************
 * Обработчик ошибок
 */
function myErrorHandler($type, $message, $file, $line)
{
	// Описания типов ошибок
	static $titles = array(
		E_ERROR             => 'Фатальная ошибка',
		E_CORE_ERROR        => 'Фатальная ошибка при запуске PHP',
		E_COMPILE_ERROR     => 'Фатальная ошибка времени компиляции',
		E_WARNING           => 'Предупреждение',
		E_CORE_WARNING      => 'Предупреждение при запуске PHP',
		E_COMPILE_WARNING   => 'Предупреждение времени компиляции',
		E_NOTICE            => 'Уведомление',
		E_USER_ERROR        => 'Ошибка, определенная пользователем',
		E_USER_WARNING      => 'Предупреждение, определенное пользователем',
		E_USER_NOTICE       => 'Уведомление, определенное пользователем',
		E_STRICT            => 'Проблема совместимости в коде',
		E_RECOVERABLE_ERROR => 'Поправимая ошибка'
	);

	// Вывод информации
	print '<h3>' . $titles[$type] . '</h3>'
		. '<p>' . $message . '<br />'
		. 'Источник: ' . basename($file) . ', line ' . $line . '<br />';

	// Получаем стек вызов и удалем из него вызов myErrorHandler
	$backtrace = debug_backtrace();
	array_shift($backtrace);

	print 'Стек вызовов:</p><ol>';

	// Выводим список вызванных функций
	foreach ($backtrace as $call) {
		print '<li>';
		if (array_key_exists('file', $call)) {
			print $call['file'] . ', line '
				. $call['line'] . ': ';
		}

		if (array_key_exists('object', $call) &&
			method_exists($call['object'], '__toString')) {

			print $call['object'];
		}

		if (array_key_exists('type', $call)) {
			if ($call['type'] == '->') {
				print $call['class'] . '->';
			} elseif ($call['type'] == '::') {
				print $call['class'] . '::';
			}
		}

		print $call['function'] . '(';

		// Печатаем аргументы функции
		$strArgs = '';
		foreach ($call['args'] as $arg) {

			if (is_null($arg)) {
				$strArgs .= 'null';

			} elseif (is_bool($arg)) {
				$strArgs .= ($arg) ? 'true' : 'false';

			} elseif (is_string($arg)) {
				$strArgs .= '"' . $arg . '"';

			} elseif (is_integer($arg) || is_float($arg)) {
				$strArgs .= $arg;

			} elseif (is_array($arg)) {
				$strArgs .= 'array (' . sizeof($arg) . ')';

			} elseif (is_object($arg)) {
				$strArgs .= 'object (' . get_class($arg) . ')';

			} elseif (is_resource($arg)) {
				$strArgs .= 'resource (' . get_resource_type($arg) . ')';
			}

			$strArgs .= ', ';
		}
		$strArgs = substr($strArgs, 0, -2);

		print $strArgs . ')</li>';
	}

	print '</ol>';

	// Стандартный обработчик ошибок нам не нужен
	return true;
}

/******************************************************************************
 * "Перехватчик" неустранимых ошибок. Получает информацию о последней ошибке
 * и передает её в функцию myErrorHandler
 */
function myFatalCatcher()
{
	$error = error_get_last();
	if ($error['type'] == E_ERROR ||
		$error['type'] == E_CORE_ERROR ||
		$error['type'] == E_COMPILE_ERROR ||
        $error['type'] == E_USER_ERROR) {

		myErrorHandler(
			$error['type'],
			$error['message'],
			$error['file'],
			$error['line']);
    }
}

set_error_handler('myErrorHandler');
register_shutdown_function('myFatalCatcher');

/******************************************************************************
 * Тест
 */

function callNotice()
{
	return $X3;
}

function callWarning()
{
	return 1 / 0;
}

function callError()
{
	doSomething();
}

function callCatchable(array $arg)
{
	return (string) $this;
}

function callUserNotice()
{
	trigger_error('Это уведомление', E_USER_NOTICE);
}

function callUserWarning()
{
	trigger_error('Это предупреждение', E_USER_WARNING);
}

function callUserError()
{
	trigger_error('Это ошибка', E_USER_ERROR);
}

function & callStrict()
{
	return 1;
}


callStrict();
callNotice();
callWarning();
callCatchable();
callUserNotice();
callUserWarning();
callUserError();
callError();