<?php

const KEY         = 'Some random string';
const NUM_CHOICES = 3;
const MIN_TIMEOUT = 3;
const MAX_TIMEOUT = 300;
const COOKIE_NAME = 'figaptcha';

require './figaptcha.php';

$selfRef = $_SERVER['PHP_SELF'];

$colours = array('european', 'asian', 'african', 'martian');
$figures = array('fair-haired', 'black-haired', 'redhead', 'completely bald');
$dimension = array(count($colours), count($figures));
$figaptcha = new Figaptcha(KEY, MIN_TIMEOUT, MAX_TIMEOUT, $dimension, NUM_CHOICES);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (!isset($_COOKIE[COOKIE_NAME])
	 || !isset($_POST['token'])
	 || !isset($_POST['capcase'])
	 || !$figaptcha->checkHash($_POST['token'], array_keys($_POST['capcase']), $_COOKIE[COOKIE_NAME])) {
		$message = 'U\'R FCKIN\' BOT!!!';
	} else {
		die('All right! <a href="'.$selfRef.'">Try again</a>');
	}
}

$items       = $figaptcha->generateItems();
$rightAnswer = $figaptcha->randomAnswer();

$some = $items[$rightAnswer[0]];
$hint = $figures[$some[1]] . ' ' . $colours[$some[0]];

$token = mt_rand(1, 1000000);

$cookieValue = $figaptcha->buildHash($token, $rightAnswer);
setcookie(COOKIE_NAME, $cookieValue, 0, '/', '', FALSE, TRUE);

?>
<!DOCTYPE HTML>
<html>
<head>
<style type="text/css">
    #message {width: 300px; padding: .5em; border: 2px solid red;}
	#figaptcha {position: relative; overflow: hidden;}
	#figaptcha .item {float: left; text-align: center;}
	#figaptcha .answer {display: block; width: 100px; height: 100px; background: url('figures3.png');}
</style>
</head>
<body>
<?php if (isset($message)): ?><p id="message"><?php echo $message ?></p><?php endif; ?>
<form action="<?php echo $selfRef ?>" method="post">
  <input type="hidden" name="token" value="<?php echo $token ?>" />
  <p>Check ALL figures wich are <strong><?php echo $hint ?></strong></p>
  <div id="figaptcha">
<?php 
foreach ($items as $i => $item) {
	list($colour, $figure) = $item;
	$x = (-$colour * 100) + (400 * mt_rand(-10, 10));
	$y = (-$figure * 100) + (400 * mt_rand(-10, 10));

?>
	<label class="item"><input name="capcase[<?php echo $i ?>]" type="checkbox"/><br /><span class="answer" style="background-position: <?php echo $x ?>px <?php echo $y ?>px"></span></label>
<?php 
}
?>
  </div>
  <input type="submit" name="submit" value="Post" />
</form>
</body>
