<?php

header('Content-type: text/html; charset: utf-8');

const KEY         = 'Some random string';
const TIMEOUT     = 300;
const COOKIE_NAME = 'figaptcha';

class Figaptcha
{
	protected $_key, $_timeout;

	function __construct($key, $timeout)
	{
		$this->_key = $key;
		$this->_timeout = $timeout;
	}

	function build($token, $data)
	{
		$expire = strval(time() + $this->_timeout);
		$x = serialize($data) . '|' . $expire;
		return strval($token) . '|' . $expire . '|' . hash_hmac('md5', $x, $this->_key);
	}

	function check($token, $data, $figaptcha)
	{
		if (!is_string($figaptcha)
		  || !preg_match('%^([^|]+)\|([0-9]+)\|([0-9a-f]+)$%', $figaptcha, $matches)
		  || $matches[1] != strval($token)
		  || intval($matches[2]) < time()
		) return FALSE;
		$x = serialize($data) . '|' . $matches[2];
		return hash_hmac('md5', $x, $this->_key) == $matches[3];
	}
}

$selfRef = $_SERVER['PHP_SELF'];
$figaptcha = new Figaptcha(KEY, TIMEOUT);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (!isset($_COOKIE[COOKIE_NAME])
	 || !isset($_POST['token'])
	 || !isset($_POST['capcase'])
	 || !$figaptcha->check($_POST['token'], array_keys($_POST['capcase']), $_COOKIE[COOKIE_NAME])) {
		$message = 'U\'R FCKIN\' BOT!!!';
	} else {
		die('Правильно! <a href="'.$selfRef.'">Попробовать еще раз</a>');
	}
}

$items = require('./questions.php');
$no = mt_rand(0, count($items) - 1);
reset($items);
$i = 0; 
while (TRUE) {
	if ($i++ == $no) {
		$hint = key($items);
		$questions = current($items);
		break;
	}
	next($items);
}

$rightAnswer = array();
foreach ($questions as $i => $case) {
	if ($case[0])
		$rightAnswer[] = $i;
}

$token = mt_rand(1, 1000000);

$cookieValue = $figaptcha->build($token, $rightAnswer);
setcookie(COOKIE_NAME, $cookieValue, 0, '/', '', FALSE, TRUE);

?>
<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<style type="text/css">
    #message {width: 300px; padding: .5em; border: 2px solid red;}
    #figaptcha ul {list-style: none; margin: 0 0 0.5; padding: 0;}
    #figaptcha ul li {line-height: 1.6;}
</style>
</head>
<body>
<?php if (isset($message)): ?><p id="message"><?php echo $message ?></p><?php endif; ?>
<form action="<?php echo $selfRef ?>" method="post">
  <input type="hidden" name="token" value="<?php echo $token ?>" />
  <p>Отметьте ВСЕ правильные варианты: <strong><?php echo $hint ?></strong></p>
  <div id="figaptcha">
  	<ul>
<?php 
foreach ($questions as $i => $case) {
?>
	<li><label class="item"><input name="capcase[<?php echo $i ?>]" type="checkbox"/><span class="answer"></span>&nbsp;<?php echo $case[1] ?></label></li>
<?php 
}
?>
	</ul>
  </div>
  <input type="submit" name="submit" value="Post" />
</form>
</body>
