<?php

const KEY         = 'Some random string';
const NUM_FIGURES = 3;
const TIMEOUT     = 300;
const COOKIE_NAME = 'figaptcha';

class Figaptcha
{
	protected $_key, $_timeout;

	function __construct($key, $timeout)
	{
		$this->_key = $key;
		$this->_timeout = $timeout;
	}

	function build($token, $data)
	{
		$expire = strval(time() + $this->_timeout);
		$x = serialize($data) . '|' . $expire;
		return strval($token) . '|' . $expire . '|' . hash_hmac('md5', $x, $this->_key);
	}

	function check($token, $data, $figaptcha)
	{
		if (!is_string($figaptcha)
		  || !preg_match('%^([^|]+)\|([0-9]+)\|([0-9a-f]+)$%', $figaptcha, $matches)
		  || $matches[1] != strval($token)
		  || intval($matches[2]) < time()
		) return FALSE;
		$x = serialize($data) . '|' . $matches[2];
		return hash_hmac('md5', $x, $this->_key) == $matches[3];
	}
}

$selfRef = $_SERVER['PHP_SELF'];
$figaptcha = new Figaptcha(KEY, TIMEOUT);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (!isset($_COOKIE[COOKIE_NAME])
	 || !isset($_POST['token'])
	 || !isset($_POST['capcase'])
	 || !$figaptcha->check($_POST['token'], array_keys($_POST['capcase']), $_COOKIE[COOKIE_NAME])) {
		$message = 'U\'R FCKIN\' BOT!!!';
	} else {
		die('All right! <a href="'.$selfRef.'">Try again</a>');
	}
}

$items = array();
for ($i = 0; $i < NUM_FIGURES; ++$i) {
	$items[] = array(mt_rand(0, 3), mt_rand(0, 3));
}

$some = $items[mt_rand(0, NUM_FIGURES - 1)];
$rightAnswer = array();
foreach ($items as $i => $item) {
	if ($item == $some)
		$rightAnswer[] = $i;
}

$colours = array('red', 'blue', 'yellow', 'grey');
$figures = array('circle', 'triangle', 'square', 'cross');
$hint = $colours[$some[0]] . ' ' . $figures[$some[1]];

$token = mt_rand(1, 1000000);

$cookieValue = $figaptcha->build($token, $rightAnswer);
setcookie(COOKIE_NAME, $cookieValue, 0, '/', '', FALSE, TRUE);

?>
<!DOCTYPE HTML>
<html>
<head>
<style type="text/css">
    #message {width: 300px; padding: .5em; border: 2px solid red;}
	#figaptcha {position: relative; overflow: hidden;}
	#figaptcha .item {float: left; text-align: center;}
	#figaptcha .answer {display: block; width: 100px; height: 100px; background: url('figures2.png');}
</style>
</head>
<body>
<?php if (isset($message)): ?><p id="message"><?php echo $message ?></p><?php endif; ?>
<form action="<?php echo $selfRef ?>" method="post">
  <input type="hidden" name="token" value="<?php echo $token ?>" />
  <p>Check ALL figures wich are <strong><?php echo $hint ?></strong></p>
  <div id="figaptcha">
<?php 
foreach ($items as $i => $item) {
	list($colour, $figure) = $item;
	$x = (-$colour * 100) + (400 * mt_rand(-10, 10));
	$y = (-$figure * 100) + (400 * mt_rand(-10, 10));

?>
	<label class="item"><input name="capcase[<?php echo $i ?>]" type="checkbox"/><br /><span class="answer" style="background-position: <?php echo $x ?>px <?php echo $y ?>px"></span></label>
<?php 
}
?>
  </div>
  <input type="submit" name="submit" value="Post" />
</form>
</body>
