<?php
/**
 * @package VkOpenApi class
 * @author Vasenin Matvey <matvey@vasenin.net>
 * @copyright © 2010 Vasenin Matvey <matvey@vasenin.net>
**/

class VkOpenApi {

	protected $_sAppId, $_iAppId, $_appPass, $_openIdFile;
	private $_vkId = NULL;

	/**
	 * Эту информацию нужно взять из приложения, которые ты добавишь вконтакте.
	 * @see http://vkontakte.ru/developers.php?o=-1&p=Open+API
	 *
	 * @var string $appId айди приожения
	 * @var string $appPass пароль приложения
	 * @var string $openIdFile в какой файл будет возвращатся информация о результате
	 */
	public function __construct ($appId, $appPass, $openIdFile) {
		$this->_iAppId = $appId;
		$this->_sAppId = "vk_app_$appId";
		$this->_appPass = $appPass;
		$this->_openIdFile = $openIdFile;
	}

	/**
    * Проверяет, залогинен ли пользователь.
	* @return mixed false или id пользователя
    */
    public function isAuth() {
        if (!isset($_COOKIE[$this->_sAppId])) {
            return false;
        }
        $vkСookie = html_entity_decode($_COOKIE[$this->_sAppId]);

        if (!empty($vkСookie)) {
			parse_str ($vkСookie, $param);
            // Проверяем sig
            $string = "expire={$param['expire']}mid={$param['mid']}secret={$param['secret']}sid={$param['sid']}{$this->_appPass}";
			//Нас наебали?
            if (md5($string) != $param['sig']) {
                return false;
            }
            $this->_vkId = $param['mid'];
			return $param['mid'];
        }

       return false;
    }
    
    /**
    * Возвращает ID вконтакте, если человек авторизован иначе false. 
    * Отличается от isAuth тем, что это не проверка аторизованнности, а плучение id.
    * То есть результаты тут как бы кешируются :)
    */
    public function getId () {
        if ( !isset($this->_vkId) ) {
            $this->_vkId = $this->isAuth();
        }
        return $this->_vkId;
    }

    /**
    * Логаут
    */
    public function logout() {
        return setcookie($this->_sAppId, '', 0, "/", '.'.$_SERVER['HTTP_HOST']) ? true : false;
    }

    /**
    * Возвращает HTML фирменной вконтактовской конопки.
    */
    public function drowVkButton() {
        return <<<HTML
		<div id="vk_api_transport"></div>
		<div id="vk_login" onclick="doLogin()"></div>
		<script src="http://vkontakte.ru/js/api/openapi.js" type="text/javascript" charset="windows-1251"></script>
		<script type="text/javascript">
		window.vkAsyncInit = function() {
		VK.init({
		apiId: {$this->_iAppId},
		nameTransportPath: '/{$this->_openIdFile}?action=receiver'
		});

		VK.UI.button('vk_login');
		};

		(function() {
		var el = document.createElement("script");
		el.type = "text/javascript";
		el.charset = "windows-1251";
		el.src = "http://vkontakte.ru/js/api/openapi.js";
		el.async = true;
		document.getElementById("vk_api_transport").appendChild(el);
		}());

		function doLogin() {
			VK.Auth.login(afterLogin);
		}

		function afterLogin (response) {
			window.location = '/{$this->_openIdFile}?action=result';
		}

		</script>
HTML;
    }

    /**
    * Возвращает HTML вашей конопки.
    */
    public function drowYorButton($button) {
        return <<<HTML
		<div id="vk_api_transport"></div>
		<div onclick="doLogin()" id="vk_login">
			{$button}
		</div>
		<script src="http://vkontakte.ru/js/api/openapi.js" type="text/javascript" charset="windows-1251"></script>
		<script type="text/javascript">
		window.vkAsyncInit = function() {
		VK.init({
		apiId: {$this->_iAppId},
		nameTransportPath: '/{$this->_openIdFile}?action=receiver'
		});

		
		};

		(function() {
		var el = document.createElement("script");
		el.type = "text/javascript";
		el.charset = "windows-1251";
		el.src = "http://vkontakte.ru/js/api/openapi.js";
		el.async = true;
		document.getElementById("vk_api_transport").appendChild(el);
		}());

		function doLogin() {
			VK.Auth.login(afterLogin);
		}

		function afterLogin (response) {
			window.location = '/{$this->_openIdFile}?action=result';
		}

		</script>
HTML;
    }

	/**
	 * Рисуем возвратку
	 */
	public function drowReceiver() {
        echo <<<HTML
			<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
			"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
			<html xmlns="http://www.w3.org/1999/xhtml">
			  <head>
				<title>Open API XD Receiver</title>
			  </head>
			  <body>
				<script src="http://vkontakte.ru/js/api/xd_receiver.js" type="text/javascript"></script>
			  </body>
			</html>
HTML;
		exit();
    }
}
