<?php
######################################################################
# MiniForum: Minimum Functionality Forum
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: user.php
# Version: 1.0
#####################################################################

class user
{
	private $id;
	private $username;
	private $password;
	private $status;
	private $register_date;
	private $register_ip;
	private $email;
	private $last_date;
	private $last_ip;
	private $real_name;
	private $sex;
	private $birthday;
	private $from_where;
	private $icq_number;
	private $about;
	
	function __construct (&$db, $id = NULL) 
	{
		$this->db = $db;
		
		if ($id === NULL)
			return true;
		else 
			$this->id = $this->db->escape_string ($id);
			
		$this->db->sql_query ('SELECT * FROM `'._USERS_TABLE.'` WHERE `id`="'.$this->id.'" LIMIT 1');
		$data = $this->db->fetchrow ();
		
		$this->username = $data['username'];
		$this->password = $data['password'];
		$this->status = $data['status'];
		$this->register_date = $data['register_date'];
		$this->register_ip = $data['register_ip'];
		$this->email = $data['email'];
		$this->lang = $data['lang'];
		$this->last_date = $data['last_date'];
		$this->last_ip = $data['last_ip'];
		$this->real_name = $data['real_name'];
		$this->sex = $data['sex'];
		$this->birthday = $data['birthday'];
		if ($this->birthday == "0000-00-00")
			$this->birthday = NULL;
		$this->from_where = $data['from_where'];
		$this->icq_number = $data['icq_number'];
		$this->about = $data['about'];
		
		return true;
	}
	
	public function is_set ()
	{
		if (isset ($this->username))
			return true;
		else
			return false;
	}
	
	public function get_id ()
	{
		return $this->id;
	}
	
	public function get_status ()
	{
		return $this->status;
	}
	
	public function get_username ()
	{
		return $this->username;
	}
	
	public function get_password ()
	{
		return $this->password;
	}
	
	public function get_lang ()
	{
		return $this->lang;
	}
	
	public function update_visit ($last_date, $last_ip)
	{
		$this->last_date = $this->db->escape_string ($last_date);
		$this->last_ip = $this->db->escape_string ($last_ip);
		
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `last_date`="'.$this->last_date.'", `last_ip`="'.$this->last_ip.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		
		return true;
	}
	
	public function create ($username, $password, $status, $register_date, $register_ip, $email, $lang, $real_name, $sex, $birthday, $from_where, $icq_number, $about)
	{
		$this->username = $this->db->escape_string (htmlspecialchars ($username));
		$this->password = md5 ($this->db->escape_string ($password));
		$this->status = $this->db->escape_string ($status);
		$this->register_date = $this->db->escape_string ($register_date);
		$this->register_ip = $this->db->escape_string ($register_ip);
		$this->email = $this->db->escape_string ($email);
		$this->lang = $this->db->escape_string ($lang);
		$this->last_date = $this->db->escape_string ($register_date);
		$this->last_ip = $this->db->escape_string ($register_ip);
		$this->real_name = $this->db->escape_string ($real_name);
		$this->sex = $this->db->escape_string ($sex);
		$this->birthday = $this->db->escape_string ($birthday);
		$this->from_where = $this->db->escape_string ($from_where);
		$this->icq_number = $this->db->escape_string ($icq_number);
		$this->about = $this->db->escape_string ($about);
		
		if ($this->real_name == "")
			$this->real_name = NULL;
		if ($this->sex == 0)
			$this->sex = NULL;
		if ($this->birthday == "")
			$this->birthday = NULL;
		if ($this->from_where == "")
			$this->from_where = NULL;
		if ($this->icq_number == "")
			$this->icq_number = NULL;
		if ($this->about == "")
			$this->about = NULL;
		 
		$this->db->sql_query ('INSERT INTO `'._USERS_TABLE.'` (`username`, `password`, `status`, `register_date`, `register_ip`, `email`, `lang`, `last_date`, `last_ip`, `real_name`, `sex`, `birthday`, `from_where`, `icq_number`, `about`) VALUES ("'.$this->username.'", "'.$this->password.'", "'.$this->status.'", "'.$this->register_date.'", "'.$this->register_ip.'", "'.$this->email.'", "'.$this->lang.'", "'.$this->last_date.'", "'.$this->last_ip.'", "'.$this->real_name.'", "'.$this->sex.'", "'.$this->birthday.'", "'.$this->from_where.'", "'.$this->icq_number.'", "'.$this->about.'")');
		
		return $this->db->insert_id ();
	}
	
	public function edit ($email, $real_name, $sex, $birthday, $from_where, $icq_number, $about)
	{
		$this->email = $this->db->escape_string ($email);
		$this->real_name = $this->db->escape_string ($real_name);
		$this->sex = $this->db->escape_string ($sex);
		$this->birthday = $this->db->escape_string ($birthday);
		$this->from_where = $this->db->escape_string ($from_where);
		$this->icq_number = $this->db->escape_string ($icq_number);
		$this->about = $this->db->escape_string ($about);
		
		if ($this->real_name == "")
			$this->real_name = NULL;
		if ($this->sex == 0)
			$this->sex = NULL;
		if (!$this->birthday)
			$this->birthday = NULL;
		if ($this->from_where == "")
			$this->from_where = NULL;
		if ($this->icq_number == "")
			$this->icq_number = NULL;
		if ($this->about == "")
			$this->about = NULL;
		
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `email`="'.$this->email.'", `real_name`="'.$this->real_name.'", `sex`="'.$this->sex.'", `birthday`="'.$this->birthday.'", `from_where`="'.$this->from_where.'", `icq_number`="'.$this->icq_number.'", `about`="'.$this->about.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		
		return true;
	}
	
	public function change_password ($password)
	{
		$this->password = md5 ($this->db->escape_string ($password));
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `password`="'.$this->password.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		return $this->password;
	}
	
	public function set_lang ($lang)
	{
		$this->lang = $this->db->escape_string ($lang);
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `lang`="'.$this->lang.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		return $this->lang;
	}
	
	public function set_ban ()
	{
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `status`=0 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function set_user ()
	{
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `status`=1 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function set_moderator ()
	{
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `status`=2 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function set_admin ()
	{
		$this->db->sql_query ('UPDATE `'._USERS_TABLE.'` SET `status`=3 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function get ()
	{
		return array (
			'id' => $this->id,
			'username' => $this->username,
			'status' => $this->status,
			'register_date' => $this->register_date,
			'register_ip' => $this->register_ip,
			'email' => $this->email,
			'last_date' => $this->last_date,
			'last_ip' => $this->last_ip,
			'real_name' => $this->real_name,
			'sex' => $this->sex,
			'birthday' => $this->birthday,
			'from_where' => $this->from_where,
			'icq_number' => $this->icq_number,
			'about' => $this->about
		);
	}
	
	public function get_users ($page)
	{
		if (($start = $this->check_user_page ($page)) === false)
			return false;
		
		$result = $this->db->sql_query ('SELECT `id`, `username`, `status`, `register_date`, `sex` FROM `'._USERS_TABLE.'` ORDER BY `register_date` ASC LIMIT '.$start.', '._USERS_IN_PAGE);
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['posts'] = $this->count_posts ($row['id']);
			$posts[] = $row;
		}
		
		return $posts;
	}
	
	public function get_full_all ($page)
	{
		if (($start = $this->check_user_page ($page)) === false)
			return false;
		
		$result = $this->db->sql_query ('SELECT * FROM `'._USERS_TABLE.'` ORDER BY `register_date` ASC LIMIT '.$start.', '._USERS_IN_PAGE);
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['posts'] = $this->count_posts ($row['id']);
			$posts[] = $row;
		}
		
		return $posts;
	}
	
	public function get_user_pages ()
	{
		$count = $this->db->result_count (_USERS_TABLE);
		$pages = ceil ($count / _USERS_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	public function login_check ($username, $password)
	{
		$this->db->sql_query ('SELECT `id` FROM `'._USERS_TABLE.'` WHERE `username`="'.$this->db->escape_string($username).'" AND `password`="'.md5($this->db->escape_string($password)).'" LIMIT 1');
		
		if ($row = $this->db->fetchrow ())
			return $row['id'];
		else
			return false;
	}
	
	public function cookie_check ($username, $password)
	{
		$this->db->sql_query ('SELECT `id` FROM `'._USERS_TABLE.'` WHERE `username`="'.base64_decode($this->db->escape_string($username)).'" AND `password`="'.base64_decode($this->db->escape_string($password)).'" LIMIT 1');
		
		if ($row = $this->db->fetchrow ())
			return $row['id'];
		else
			return false;
	}
	
	private function check_user_page ($page)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_USERS_TABLE);
		
		$pages = ceil ($count / _USERS_IN_PAGE);
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _USERS_IN_PAGE;
	}
	
	private function count_posts ($id)
	{
		return $this->db->result_count (_POSTS_TABLE, '`creator`="'.$this->db->escape_string($id).'"');
	}
	
	
	public function check_username ($username, db $db)
	{
		if ((strlen ($username) > 32) || (strlen ($username) < _MIN_LOGIN_LENGTH))
			return false;
		else
		{
			if (preg_match ("/\S{"._MIN_LOGIN_LENGTH.",32}/is", $username))
			{
				$this->db->sql_query ('SELECT `id` FROM `'._USERS_TABLE.'` WHERE `username`="'.$db->escape_string($username).'" LIMIT 1');
				if ($db->fetchrow ())
					return false;
				else 
					return $username;
			}
			else
				return false;
		}
	}
	
	public function check_password ($password)
	{
		if ((strlen ($password) > 32) || (strlen ($password) < _MIN_PASSWORD_LENGTH))
			return false;
		else
		{
			if (preg_match ("/\S{"._MIN_PASSWORD_LENGTH.",32}/is", $password))
				return md5 ($password);
			else
				return false;
		}
	}
	
	public function check_email ($email)
	{
		if ((strlen ($email) > 64) || (strlen ($email) < 8))
			return false;
		else
		{
			if (preg_match ("/(\S+)@([a-z0-9]+)(\.)([a-z]{2,4})/is", $email))
				return $email;
			else
				return false;
		}
	}
	
	public function check_birthday ($day, $month, $year)
	{
		if (($day == "") && ($month == 0) && ($year == ""))
			return true;
		
		if (strlen ($year) != 4)
			return false;
		else
		{
			if (preg_match ("/\d{4}/is", $year))
			{
				if (($year > date("Y")) || ($year < 1900))
					return false;
				else
					$birtday = $year."-";
			}
			else
				return false;
		}
		
		if (strlen ($month) > 2)
			return false;
		else
		{
			if (preg_match ("/\d{1,2}/is", $month))
			{
				if (($month > 12) || ($month < 1))
					return false;
				else
				{
					if ($month < 10)
						$month = "0".$month;
					$birtday .= $month."-";
				}
			}
			else
				return false;
		}
		
		if (strlen ($day) > 2)
			return false;
		else
		{
			if (preg_match ("/\d{1,2}/is", $day))
			{
				if (($day > 31) || ($day < 1))
					return false;
				else
				{
					if ($day < 10)
						$day = "0".$day;
					$birtday .= $day;
				}
			}
			else
				return false;
		}
		
		return $birtday;
	}
	
	public function check_icq ($icq)
	{
		if ($icq == "")
			return true;
		
		if ((strlen ($icq) > 10) || (strlen ($icq) < 5))
			return false;
		else
		{
			if (preg_match ("/\d{5,10}/is", $icq))
				return $icq;
			else
				return false;
		}
	}
}

?>