<?php
######################################################################
# MiniForum: Minimum Functionality Forum
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: theme.php
# Version: 1.0
#####################################################################

class theme
{
	private $id;
	private $status;
	private $title;
	private $create_date;
	private $create_ip;
	private $last_update;
	
	private $creator;
	
	private $posts;
	
	private $db;
	
	function __construct (&$db, $id = NULL) 
	{
		$this->db = $db;
		
		if ($id === NULL)
			return true;
		else 
			$this->id = $this->db->escape_string ($id);
		
		$this->db->sql_query ('SELECT * FROM `'._THEMES_TABLE.'` WHERE `id`="'.$this->id.'" LIMIT 1');
		
		if (!$data = $this->db->fetchrow ())
			return false;
		
		$this->status = $data['status'];
		$this->title = $data['title'];
		$this->create_date = $data['create_date'];
		$this->create_ip = $data['create_ip'];
		$this->last_update = $data['last_update'];
		
		$this->creator = new user ($this->db, $data['creator']);
		
		return true;
	}
	
	public function is_set ()
	{
		if (isset ($this->status))
			return true;
		else
			return false;
	}
	
	public function get_id ()
	{
		return $this->id;
	}
	
	public function get_title ()
	{
		return $this->title;
	}
	
	public function get_status ()
	{
		return $this->status;
	}
	
	public function get ()
	{
		return array (
			'id' => $this->id,
			'title' => $this->title,
		);
	}
	
	public function create ($title, $status, $creator, $create_date, $create_ip)
	{
		$this->title = $this->db->escape_string (htmlspecialchars ($title));
		$this->creator = new user ($this->db, $creator);
		$this->create_date = $this->db->escape_string ($create_date);
		$this->create_ip = $this->db->escape_string ($create_ip);
		$this->status = $this->db->escape_string ($status);
		$this->last_update = $this->db->escape_string ($create_date);
		
		$this->db->sql_query ('INSERT INTO `'._THEMES_TABLE.'` (`status`, `title`, `creator`, `create_date`, `create_ip`, `last_update`) VALUES ("'.$this->status.'", "'.$this->title.'", "'.$this->creator->get_id().'", "'.$this->create_date.'", "'.$this->create_ip.'", "'.$this->last_update.'")');
		
		$this->id = $this->db->insert_id ();
		
		return $this->id;
	}
	
	public function delete ($type = _DELETE_TYPE)
	{
		if ($type == 0)
			$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `status`=0 WHERE `id`="'.$this->id.'" LIMIT 1');
		else
			$this->db->sql_query ('DELETE FROM `'._THEMES_TABLE.'` WHERE `id`="'.$this->id.'" LIMIT 1');
		
		return true;
	}
	
	public function set_last_update ($update)
	{
		$this->last_update = $this->db->escape_string ($update);
		$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `last_update`="'.$this->last_update.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		return $this->last_update;
	}
	
	public function edit_title ($title)
	{
		$this->title = $this->db->escape_string (htmlspecialchars ($title));
		$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `title`="'.$this->title.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		return $this->title;
	}
	
	public function open ()
	{
		$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `status`=1 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function close ()
	{
		$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `status`=2 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function restore ()
	{
		$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `status`=1 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function get_full_all ($page = 1)
	{
		if (($start = $this->check_theme_page_full ($page)) === false)
			return false;
		
		$result = $this->db->sql_query ('SELECT * FROM `'._THEMES_TABLE.'` ORDER BY `last_update` DESC LIMIT '.$start.', '._THEMES_IN_PAGE);
		
		$themes = array ();
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['creator_username'] = $this->get_creator_by_id ($row['creator']);
			$row['last_poster'] = $this->get_last_poster ($row['id']);
			$row['last_poster_id'] = $this->get_last_poster_id ($row['id']);
			$row['count_posts'] = $this->get_count_posts ($row['id']);
			$themes[] = $row;
		}
		
		return $themes;
	}
	
	public function get_themes ($page = 1)
	{
		if (($start = $this->check_theme_page ($page)) === false)
			return false;
		
		$result = $this->db->sql_query ('SELECT `id`, `status`, `title`, `creator`, `last_update` FROM `'._THEMES_TABLE.'` WHERE `status`!=0 ORDER BY `last_update` DESC LIMIT '.$start.', '._THEMES_IN_PAGE);
		
		$themes = array ();
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['creator_username'] = $this->get_creator_by_id ($row['creator']);
			$row['last_poster'] = $this->get_last_poster ($row['id']);
			$row['last_poster_id'] = $this->get_last_poster_id ($row['id']);
			$row['count_posts'] = $this->get_count_posts ($row['id']) - 1;
			$row['post_pages'] = $this->get_pages_for_main ($row['id']);
			$themes[] = $row;
		}
		
		return $themes;
	}
	
	public function get_full_all_posts ($page)
	{
		if (($start = $this->check_post_page_full ($page)) === false)
			return false;
			
		$result = $this->db->sql_query ('SELECT * FROM `'._POSTS_TABLE.'` WHERE `theme`="'.$this->id.'" ORDER BY `create_date` ASC LIMIT '.$start.', '._POSTS_IN_PAGE);
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['text'] = nl2br ($row['text']);
			$row['creator_username'] = $this->get_creator_by_id ($row['creator']);
			$row['creator_status'] = $this->get_creator_status ($row['creator']);
			$posts[] = $row;
		}
		
		return $posts;
	}
	
	public function get_posts ($page = 1)
	{
		if (($start = $this->check_post_page ($page)) === false)
			return false;
			
		$result = $this->db->sql_query ('SELECT `id`, `status`, `text`, `creator`, `create_date` FROM `'._POSTS_TABLE.'` WHERE `theme`="'.$this->id.'" AND `status`!=0 ORDER BY `create_date` ASC LIMIT '.$start.', '._POSTS_IN_PAGE);
		
		$posts = array ();
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['text'] = nl2br ($row['text']);
			$row['creator_username'] = $this->get_creator_by_id ($row['creator']);
			$row['creator_status'] = $this->get_creator_status ($row['creator']);
			$posts[] = $row;
		}
		
		return $posts;
	}
	
	public function get_theme_pages ()
	{
		$count = $this->db->result_count (_THEMES_TABLE, '`status`!=0');
		$pages = ceil ($count / _THEMES_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	public function get_theme_pages_full ()
	{
		$count = $this->db->result_count (_THEMES_TABLE);
		$pages = ceil ($count / _THEMES_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	public function get_post_pages ()
	{
		$count = $this->db->result_count (_POSTS_TABLE, '`theme`="'.$this->id.'" AND `status`!=0');
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	public function get_post_pages_full ()
	{
		$count = $this->db->result_count (_POSTS_TABLE, '`theme`="'.$this->id.'"');
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	public function get_themes_search ($page = 1, $query)
	{
		if (($start = $this->check_theme_page_search ($page, $query)) === false)
			return false;
		
		$result = $this->db->sql_query ('SELECT `id`, `status`, `title`, `creator`, `last_update` FROM `'._THEMES_TABLE.'` WHERE (locate(lower("'.$this->db->escape_string($query).'"),lower(`title`))>0) AND `status`!=0 ORDER BY `last_update` DESC LIMIT '.$start.', '._THEMES_IN_PAGE);
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['creator_username'] = $this->get_creator_by_id ($row['creator']);
			$row['last_poster'] = $this->get_last_poster ($row['id']);
			$row['last_poster_id'] = $this->get_last_poster_id ($row['id']);
			$row['count_posts'] = $this->get_count_posts ($row['id']) - 1;
			$themes[] = $row;
		}
		
		return $themes;
	}
	
	public function get_posts_search ($page = 1, $query)
	{
		if (($start = $this->check_post_page_search ($page, $query)) === false)
			return false;
			
		$result = $this->db->sql_query ('SELECT `id`, `status`, `text`, `creator`, `create_date` FROM `'._POSTS_TABLE.'` WHERE (locate(lower("'.$this->db->escape_string($query).'"),lower(`text`))>0) ORDER BY `create_date` ASC LIMIT '.$start.', '._POSTS_IN_PAGE);
		
		while ($row = $this->db->fetchrow ($result))
		{
			$row['text'] = nl2br ($row['text']);
			$row['creator_username'] = $this->get_creator_by_id ($row['creator']);
			$row['creator_status'] = $this->get_creator_status ($row['creator']);
			$posts[] = $row;
		}
		
		return $posts;
	}
	
	public function get_theme_pages_search ($quert)
	{
		$count = $this->db->result_count (_THEMES_TABLE, '(locate(lower("'.$this->db->escape_string($query).'"),lower(`text`))>0) AND `status`!=0');
		$pages = ceil ($count / _THEMES_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	public function get_post_pages_search ($query)
	{
		$count = $this->db->result_count (_POSTS_TABLE, '(locate(lower("'.$this->db->escape_string($query).'"),lower(`text`))>0) AND `status`!=0');
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
	
	private function check_theme_page ($page)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_THEMES_TABLE, '`status`!=0');
		
		$pages = ceil ($count / _THEMES_IN_PAGE);
		
		if ($pages == 0)
			return true;
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _THEMES_IN_PAGE;
	}
	
	private function check_theme_page_full ($page)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_THEMES_TABLE);
		
		$pages = ceil ($count / _THEMES_IN_PAGE);
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _THEMES_IN_PAGE;
	}
	
	private function check_post_page ($page)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_POSTS_TABLE, '`status`!=0');
		
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($pages == 0)
			return true;
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _POSTS_IN_PAGE;
	}
	
	private function check_post_page_full ($page)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_POSTS_TABLE);
		
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _POSTS_IN_PAGE;
	}
	
	private function check_theme_page_search ($page, $query)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_THEMES_TABLE, '(locate(lower("'.$this->db->escape_string($query).'"),lower(`title`))>0) AND `status`!=0');
		
		$pages = ceil ($count / _THEMES_IN_PAGE);
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _THEMES_IN_PAGE;
	}
	
	private function check_post_page_search ($page, $query)
	{
		if (settype ($page, "int") === NULL)
			return false;
		
		$count = $this->db->result_count (_POSTS_TABLE, '(locate(lower("'.$this->db->escape_string($query).'"),lower(`text`))>0) AND `status`!=0');
		
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($page < 1 || $page > $pages)
			return false;
		
		return ($page - 1) * _POSTS_IN_PAGE;
	}
	
	private function get_creator_by_id ($id)
	{
		$this->db->sql_query ('SELECT `username` FROM `'._USERS_TABLE.'` WHERE `id`="'.$this->db->escape_string($id).'" LIMIT 1');
		$creator = $this->db->fetchrow ();
		return $creator['username'];
	}
	
	private function get_creator_status ($id)
	{
		$this->db->sql_query ('SELECT `status` FROM `'._USERS_TABLE.'` WHERE `id`="'.$this->db->escape_string($id).'" LIMIT 1');
		$status = $this->db->fetchrow ();
		return $status['status'];
	}
	
	private function get_last_poster ($id)
	{
		$creator = $this->get_last_poster_id ($id);
		$this->db->sql_query ('SELECT `username` FROM `'._USERS_TABLE.'` WHERE `id`="'.$this->db->escape_string($creator).'" LIMIT 1');
		$poster = $this->db->fetchrow ();
		return $poster['username'];
	}
	
	
	private function get_last_poster_id ($id)
	{
		$this->db->sql_query ('SELECT `creator` FROM `'._POSTS_TABLE.'` WHERE `theme`="'.$this->db->escape_string($id).'" ORDER BY `create_date` DESC LIMIT 1');
		$creator = $this->db->fetchrow ();
		return $creator['creator'];
	}
	
	private function get_count_posts ($id)
	{
		return $this->db->result_count (_POSTS_TABLE, '`theme`="'.$this->db->escape_string($id).'"');
	}
	
	private function get_pages_for_main ($id)
	{
		$count = $this->db->result_count (_POSTS_TABLE, '`theme`="'.$this->db->escape_string($id).'" AND `status`!=0');
		$pages = ceil ($count / _POSTS_IN_PAGE);
		
		if ($pages > 1)
		{
			for ($i = 1; $i <= $pages; $i++)
				$pages_array[] = $i;
			return $pages_array;
		}
		else
			return false;
	}
}

?>