<?php

error_reporting(-1);

class AliasArray
{
	private
		$_values;

	public function get($chain = '')
	{
		$ref =& $this->_values;
		if ($chain != '')
		{
			foreach (explode('.', $chain) as $name)
			{
				if (isset($ref[$name])) $ref =& $ref[$name];
				else return NULL;
			}
		}
		return $ref;
	}

	public function set($chain, $value)
	{
		$ref =& $this->_values;
		foreach (explode('.', $chain) as $name)
		{
			if ($name == '*') {
				$ref[] = NULL;
				end($ref);
				$name = key($ref);
			} else if (!isset($ref[$name])) {
				$ref[$name] = NULL;
			}
			$ref =& $ref[$name];
		}
		$ref = $value;
	}

	private
		$_items;

	public function getFlat($chain = '')
	{
		$tmp = $this->get($chain);
		$this->_items = array();
		array_walk_recursive($tmp, array($this, '_addItem'));
		return $this->_items;
	}

	private function _addItem($item)
	{
		$this->_items[] = $item;
	}
}

$x = new AliasArray();

$x->set('z', '@');
$x->set('alpha.beta.omega', 'a');
$x->set('alpha.*', 'b');
$x->set('alpha.*.theta', 'c');
$x->set('alpha.*', 'd');
$x->set('alpha.*.gama', 'e');

header('Content-type: text/plain');
echo 'alpha: ' . var_export($x->get('alpha'), TRUE) . "\n";
echo 'all array as flat: ' . var_export($x->getFlat(), TRUE) . "\n";
