<?php

Class Fsocket
{
	public static $cookies='';
	
	protected static $timeout;
	protected static $portion;
	
	public static $request;
	public static $response;
	
	public function __construct($timeout=30, $portion=2048)
	{
		self::$timeout = $timeout;
		self::$portion = $portion;
	}

	public static function Send($url, $data = "", $method = "get", $cookies = "")
	{
	    $arr = parse_url($url);
		
		if (empty($cookies))
			$cookies = self::$cookies;

	    $nn 	= "\r\n";
	    $host 	= $arr["host"];
	    $ref 	= $arr["scheme"] . "//" . $host;
	    $path 	= $arr["path"];
		if (empty($path)) {
			$path = '/';
		}

	    if (isset($arr['query'])) $query = $arr["query"];

	    if (isset($query) && !empty($query)) $path.="?".$query;

	    $request = strtoupper($method)." " . $path . " HTTP/1.0" . $nn .
	               "Referer: " . $ref . $nn .
	               ($cookies ? "Cookie: " . $cookies . $nn : "") .
	               "Connection: Keep-Alive" . $nn .
	               "Cache-Control: no-cache" . $nn .
	               "Host: " . $host . $nn .
	               "Accept: */*" . $nn .
	               "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; MyIE2)" . $nn . $nn .
	               $data;

	    //echo nl2br($request).'<br />';
		//exit;
		
		self::$request = $request;
	    
	    $fp = fsockopen($host, 80, &$errno, &$errstr, self::$timeout);
		
		if(!$fp) { print "$errstr ($errno)<br>\n"; exit; }

	    fwrite($fp, $request);

		$reply='';
		
		while (!feof($fp))
			$reply .= fgets($fp, self::$portion);
		
		fclose($fp);
		
		$e = preg_split('~(\r\n\r\n)|(\n\r\n\r)|(\n\n)|(\r\r)~', $reply, 2);
		
		self::$response = $e[0];
		
		$body = isSet($e[1]) ? $e[1] : '';

	    return ($body);
	}

	
	
	//  
	public static function GetCookies($headers)
	{
		$cookie = "";
		$arr = split("\r\n", $headers);
		$j = count($arr);

		for($i=0; $i < ($j-1); $i++)
		{
			if(ereg("^Set-Cookie:",$arr[$i]))
			{
		        list($cv) = split( ";", $arr[$i]);
		        list($trash, $cv) = split( ":", $cv);
		        list($cname, $cv) = split( "=", $cv, 2);
		        $cookie .= $cname . "=" . urlencode($cv) . "; ";
			}
		}

	    return (urldecode($cookie));
	}
	
	
	
	//   Location
	public static function GetLocation($headers)
	{
		$arr = split("\r\n", $headers);
		$c = count($arr);
		
		for($i=0; $i<($c-1); $i++)
		{
			preg_match('#^Location:(.*)$#', $arr[$i], $m);
			
			if (!empty($m))
			{
				return(trim($m[1]));
			}
		}
		
		return(false);
	}
}

?>