<?php

class Figaptcha
{
	protected 
		$_key, 
		$_timeoutMin, 
		$_timeoutMax,
		$_dimension,
		$_num,
		$_items;

	function __construct($key, $timeoutMin, $timeoutMax, $dimension = NULL, $num = 0)
	{
		$this->_key        = $key;
		$this->_timeoutMin = $timeoutMin;
		$this->_timeoutMax = $timeoutMax;
		$this->_dimension  = $dimension;
		$this->_num        = $num;
	}

	function buildHash($token, $data)
	{
		$expire = strval(time() + $this->_timeoutMax);
		$x = serialize($data) . '|' . $expire;
		return strval($token) . '|' . $expire . '|' . hash_hmac('md5', $x, $this->_key);
	}

	function checkHash($token, $data, $hash)
	{
		if (!preg_match('%^([^|]+)\|([0-9]+)\|([0-9a-f]+)$%', $hash, $matches)
		  || $matches[1] != strval($token)
		  || intval($matches[2]) < time()
		  || intval($matches[2]) > time() + $this->_timeoutMax - $this->_timeoutMin
		) return FALSE;
		$x = serialize($data) . '|' . $matches[2];
		return hash_hmac('md5', $x, $this->_key) == $matches[3];
	}

	function generateItems()
	{
		$this->_items = array();
		if (is_array($this->_dimension)) {
			for ($i = 0; $i < $this->_num; ++$i) {
				$item = array();
				foreach ($this->_dimension as $d)
					$item[] = mt_rand(0, $d - 1);
				$this->_items[] = $item;
			}
		} else {
			for ($i = 0; $i < $this->_num; ++$i)
				$this->_items[] = mt_rand(0, $this->_dimension - 1);
		}
		return $this->_items;
	}

	function randomAnswer()
	{
		$some = $this->_items[mt_rand(0, $this->_num - 1)];
		$answer = array();
		foreach ($this->_items as $i => $item) {
			if ($item == $some)
				$answer[] = $i;
		}
		return $answer;
	}
}
