<?php

header('Content-type: text/html; charset: UTF-8');

const KEY         = 'Some random string';
const NUM_CHOICES = 16;
const MIN_TIMEOUT = 0;
const MAX_TIMEOUT = 300;
const COOKIE_NAME = 'figaptcha';

function classVisible($value)
{
	$classes = array(TRUE => array('c2', 'c4'), FALSE => array('c1', 'c3'));
	$a = $classes[(boolean)$value];
	return $a[array_rand($a, 1)];
}

function kshuffle(&$array)
{
	if (!is_array($array) || count($array) == 0) return FALSE;
	$keys = array_keys($array);
	shuffle($keys);
	$result = array();
	foreach ($keys as $key)
		$result[$key] = $array[$key];
	$array = $result;
	return TRUE;
}

$selfRef = $_SERVER['PHP_SELF'];

require './figaptcha.php';
$figaptcha = new Figaptcha(KEY, MIN_TIMEOUT, MAX_TIMEOUT);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (!isset($_COOKIE[COOKIE_NAME])
	 || !isset($_POST['token'])
	 || !isset($_POST['capcase'])
	 || !$figaptcha->checkHash($_POST['token'], array_keys($_POST['capcase']), $_COOKIE[COOKIE_NAME])) {
		$message = 'Ах ты негодяй!!!';
	} else {
		die('Правильно! <a href="'.$selfRef.'">Попробовать еще раз</a>');
	}
}

$wholeQuestions = require('./questions.php');
$hint = array_rand($wholeQuestions, 1);
$questions = $wholeQuestions[$hint];

// add some garbage
foreach ($wholeQuestions as $h => $q) {
	foreach ($q as $k => $v) {
		if (!array_key_exists($k, $questions))
			$questions[$k] = NULL;
		if (count($questions) >= NUM_CHOICES)
			break 2;
	}
}
kshuffle($questions);
$rightAnswer = array_keys(array_filter(array_values($questions)));

$token = mt_rand(1, 1000000);

$cookieValue = $figaptcha->buildHash($token, $rightAnswer);
setcookie(COOKIE_NAME, $cookieValue, 0, '/', '', FALSE, TRUE);

?>
<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<style type="text/css">
    #message {width: 300px; padding: .5em; border: 2px solid red;}
    #figaptcha ul {list-style: none; margin: 0 0 0.5; padding: 0;}
    #figaptcha ul li {line-height: 1.6;}
    #figaptcha .c1 {display: none;}
    #figaptcha .c2 {display: block;}
    #figaptcha .c3 {display: none;}
    #figaptcha .c4 {display: block;}
</style>
</head>
<body>
<?php if (isset($message)): ?><p id="message"><?php echo $message ?></p><?php endif; ?>
<form action="<?php echo $selfRef ?>" method="post">
  <input type="hidden" name="token" value="<?php echo $token ?>" />
  <p>Вопрос без подвоха. Просто отметьте ВСЕ правильные варианты:<br/><strong><?php echo $hint ?></strong></p>
  <div id="figaptcha">
  	<ul>
<?php 
$i = 0;
foreach ($questions as $case => $ok) {
?>
	<li class="<?php echo classVisible($ok !== NULL) ?>"><label class="item"><input name="capcase[<?php echo $i++ ?>]" type="checkbox"/><span class="answer"></span>&nbsp;<?php echo $case ?></label></li>
<?php 
}
?>
	</ul>
  </div>
  <input type="submit" name="submit" value="Post" />
</form>
</body>
