<?php

$persons = array('Frozegg', 'KaFe', 'Kostyl', 'Artoodetoo');
$u = '/alfa/beta-gamma/sigma';
$c = '\Alfa/BetaGamma\Sigma';
 
foreach ($persons as $person) {
    require("./{$person}.php");

	if (method_exists($person, 'pathToClass')) {
		$t = microtime(TRUE);
		for ($i=1; $i<1000; ++$i)
		    $s = $person::pathToClass($u);
		$t = microtime(TRUE) - $t;
		$pathToClass[$person] = array($s, $t);
	} else {
		$pathToClass[$person] = array('---', '---');
	}

	if (method_exists($person, 'classToPath')) {
		$t = microtime(TRUE);
		for ($i=1; $i<1000; ++$i)
		    $s = $person::classToPath($c);
		$t = microtime(TRUE) - $t;
		$classToPath[$person] = array($s, $t);
	} else {
		$classToPath[$person] = array('---', '---');
	}
}
		

// View

echo <<<EOT
<style> 
	.compare {border-collapse: collapse}
	.compare td, .compare th {font-family: sans-serif; font-size: 10pt; padding: 4px; border: 1px dotted #bbb}
	.compare tr.odd td {background: #eee}
</style>
<table class="compare">

EOT;

foreach ($persons as $person)
{
	$even = $pathToClass[$person];
	$odd  = $classToPath[$person];

echo <<<EOT
<tr class="even">
	<th rowspan="2">{$person}:</th>
	<td>{$even[0]}</td>
	<td>{$even[1]}</td>
</tr>
<tr class="odd">
	<td>{$odd[0]}</td>
	<td>{$odd[1]}</td>
</tr>

EOT;
}

echo "</table>\n";
