<?php
/**
 * FireBear Screen Bot
 *
 * Планируется:
 * 1. структурирование файлов по папкам
 * 2. работа с базой данных
 * 3. работа с различными типами изображений
 * 4. создание скриншотов с окон серверных запущенных приложений
 * 
 * @author Mars
 * @version 0.0.1
 */
class Firebear
{
	/** шаблон пути к скриншоту */
	public $filepattern = 'screens/<FILE>.jpg';
	
	/** путь к файлу ошибки */
	public $badfilepath = 'bad.jpg';
	
	/**
	 * Размер оптимизированого изображения.
	 * Формат: width:height
	 *
	 * Если указать вместо какого-либо из параметров 0, 
	 * то во время оптимизации он не изменится.
	 *
	 * если original size = 500x500 то:
	 * 458:343 	- width 458, height 343
	 * 458:0 	- width 458, height 500
	 * 0:400 	- width 500, height 400
	 * 0:0 		- width 500, height 500
	 */
	public $screenssize = '458:343';
	
	/** использовать оптимизатор true/false */
	public $gdoptimizer = false;
	
	/**
	 * Конструктор класса
	 * @param array $config конфигурация класса
	 */
	public function __construct ($config = false)
	{
		if (is_array($config))
		{
			foreach ($config as $key => $value)
			{
				$this->$key = $value;
			}
		}
	}
	
	/**
	 * Создать скриншот [и вывести его в браузер если makeonly = false]
	 * @param string $text текст для поиска скриншота
	 * @param bool $makeonly показать скриншот (false) или только создать его (true)
	 * @param string $fname имя файла, если false то используется шаблон
	 * @return mixed
	 */
	public function ShowScreen ($text, $makeonly = false, $fname = false)
	{
		$fname = ($fname) ? $fname : str_replace('<FILE>', md5($text), $this->filepattern);
		if (! file_exists($fname)) {
			if (! $result = $this->GetImageFromGoogle($text, $fname)) {
				$this->NoScreenShotAvailable($fname);
			}	$this->InitImageOptimizer($fname);
		 }
		if ($makeonly) return $fname;
		header("Location: $fname", true, 302);
		exit;
	}
	
	/**
	 * Оптимизировать скриншот, подогнав его под нужные размеры
	 * @param string $fname имя файла
	 */
	public function InitImageOptimizer ($fname)
	{
		if ($this->gdoptimizer && function_exists('imagetypes'))
		{
			list($width, $height, $type, $attr) = getimagesize($fname);
			$needwidth = intval(strtok($this->screenssize, ':'));
			$needheight = intval(strtok(':'));
			if ($needwidth === 0) $needwidth = $width;
			if ($needheight === 0) $needheight = $height;
			if (!(($width === $needwidth) && ($height === $needheight)))
			{
				if ($type === IMAGETYPE_JPEG)
				{
					$source = imagecreatefromjpeg($fname);
					$to = imagecreatetruecolor($needwidth, $needheight);
					imagecopyresized($to, $source, 0, 0, 0, 0, $needwidth, $needheight, $width, $height);
					unlink($fname); imagejpeg($to, $fname); imagedestroy($to); imagedestroy($source);
				}
			}
		}
	}
	
	/**
	 * Создать скриншот используя badfilepath
	 * @param string $fname имя файла
	 */
	public function NoScreenShotAvailable ($fname)
	{
		if ($src = @fopen($this->badfilepath, 'r'))
		{
			$write = fopen($fname, 'w');
			stream_copy_to_stream($src, $write);
			fclose($fname);
		}
		else
		{
			header("HTTP/1.1 404 Not Found");
			exit;
		}
	}
	
	/**
	 * Создать скриншот используя Google Images
	 * @param string $text текст для поиска скриншота
	 * @param string $fname имя файла, если false то используется шаблон
	 * @return bool
	 */
	public function GetImageFromGoogle ($text, $fname = false)
	{
		$fname = ($fname) ? $fname : str_replace('<FILE>', md5($text), $this->filepattern);
		$request = file_get_contents("http://images.google.com/images?hl=ru&source=imghp&safe=off&tbs=isch:1,isz:m&source=lnt&q=".urlencode($text));
		preg_match_all("/imgurl\S+(http\:\/\/\S+jpe?g)\S+imgrefurl/i", $request, $out);
		if ($src = @fopen($out[1][0], 'r'))
		{
			$write = fopen($fname, 'w');
			stream_copy_to_stream($src, $write);
			fclose($fname);
			return true;
		}
		else
		{
			return false;
		}
	}
}