<?php
/*
@ Extra LibCurl Class
@ Version: 1.0.1
@ Author: Mars
@ PhpRequired: 5.3

	*      *
	----------------------------------------------------
	-     : require_once 'extra.curl.php'; $curl = new libcurl;
	-   CURL   (point)
	-     ,    
	-       point  upoint:
	
		  point:
		$curl->point('ch', array('url' => 'http://example.com'));
		
		      :
		$curl->upoint('http://example.com');
		
		  :
		echo $curl->point('ch', array('url' => 'http://example.com'))->exec();
		echo $curl->upoint('http://example.com')->exec();
		
		  (    ):
		file_put_contents('log.txt', $curl->upoint('http://example.com')->exec());
		
		   ():
		$curl->upoint('http://example.com');
		$curl->upoint('http://google.com');
		$curl->upoint('http://yandex.ru');
		$curl();
		
		 :
		$curl->point('ch', array('url' => 'http://example.com'));
		$curl->point('ch', array('url' => 'http://google.com'));
		$curl->point('ch', array('url' => 'http://yandex.ru'));
		$curl();
		
		:   $curl();  $curl->exec(); (   )
		
	-       
		
		  :
		*     upoint,      chX,  X        (ch0, ch1, ch2  ...)
		*     ,      
		*        ()
		*    -     curl   ,        curl_setopt,    CURLOPT_    
		
		$curl->upoint('http://example.com');
		$curl->ch0->returntransfer = 0; //     
		$curl->exec();
		
		$curl->point('xch', array('url' => 'http://example.com'));
		$curl->xch->httpheader = array('blablabla'); //   blablabla
		echo $curl->exec();
		
		     set:
		$curl->point('xch', array('url' => 'http://example.com'));
		$myoptions = array('useragent' => 'Mozilla', 'header' => 1, 'followlocation' => 1);
		$curl->xch->set($myoptions); $result = $curl(); echo $result;
		
		  :
		$curl->upoint('http://example.com');
		$curl->ch0->header = 1;
		file_put_contents('log.txt', $curl());
		
		   :
		echo $curl->xch->url ? : 'url  ';
		
		  "and"  "upoint":
		$curl->upoint('http://google.ru')->and->followlocation = 1;
		$curl->upoint('http://example.com');
		$result = $curl->exec(); 
		file_put_contents('log.txt', serialize($result));
		
		   "upoint", "and"  "set":
		$curl->upoint('http://google.ru')->and->set(array(
			'followlocation' => true,
			'header' => true,
			'fresh_connect' => true,
		));

		file_put_contents('log.txt', $curl());
		
		 secure()       :
		$curl->upoint('http://google.ru')->and->secure()->set(array(
			'followlocation' => true,
			'header' => true,
			'fresh_connect' => true,
		));
		$curl(); $curl(); $curl();
		file_put_contents('log.txt', $curl());
		
		    :
		$curl->upoint('http://google.ru')->and->set(array(
			'followlocation' => true,
			'header' => true,
			'fresh_connect' => true,
		))->secure();
		$curl->exec();
		$curl->and->secure(false); //    and    ch0
		$curl->exec(); // 
		file_put_contents('log.txt', (!$curl())?' ':''); //  
		
		 cookies:
		$result = $curl->point('ch', array('url' => 'http://vk.com', 'header' => 1))->exec();
		var_dump(libcurl::parse_cookies($result));
		
		 cookies:
		$result = $curl->point('ch', array('url' => 'http://vk.com', 'header' => 1))->exec();
		$mycookies = libcurl::parse_cookies($result);
		echo libcurl::prepare_cookies($mycookies);
		
	-       
	-         (    ): header 0  returntransfer 1
	-   libcurl    curl,       ,      
	-    ,        
	-  CURLINFO_, CURLCLOSEPOLICY_, CURLE_  info::, closepolicy::  e:: ( info::total_time)
	
	*    *
	url  - URL,     
	infilesize -      ,         
	verbose -        cURL        
	header -            
	noprogress -             
	nobody -             (,     )
	failonerror -       ,  HTTP   300  
	upload -       ,        
	post -          HTTP   POST  application/x-www-form-urlencoded,     
	ftplistonly -              FTP 
	followlocation -       ,   HTTP  "Location: "        URL (   ,     "Location:")
	referer -   HTTP  "Referer: "
*/


class libcurl
{
	/*    */
	public $points = array();

	/* point ([ point name,  point data]) -   */
	public function point($pn=false, $pointdata=false)
	{
		$point_name = (!$pn) ? 'ch'.count($this->points) : $pn;
		$this->$point_name = new curlpoint($pointdata);
		$this->points[] = $point_name;
		$this->and = $this->$point_name;
		return $this;
	}
	
	/* upoint ( URL) -      ,    URL */
	public function upoint($url)
	{
		return $this->point(false, array('URL' => $url));
	}
	
	private function join_option($option)
	{
		$token = strtok($option, '::');
		switch($token)
		{
			case 'info': return constant('CURLINFO_'.strtoupper($option)); break;
			case 'closepolicy': return constant('CURLCLOSEPOLICY_'.strtoupper($option)); break;
			case 'e': return constant('CURLE_'.strtoupper($option)); break;
			default: return constant('CURLOPT_'.strtoupper($option));
		}
	}
	
	/*     */
	public static function parse_cookies($req)
	{
		preg_match_all('/Set-Cookie:\040(.+?)(\n|$)/s', $req, $cookies_requested);
		return (isset($cookies_requested[1])) ? $cookies_requested[1] : false;
	}
	
	/*       ,     curl */
	public static function prepare_cookies($req)
	{
		return trim(preg_replace(array('/((expires|path|domain)=.+?|secure|httponly|\S+=deleted)(;|$)/', '/\s\s/'), array('', ' '), str_replace(
			array("\n", "\r", ';;'), array('', '', ';'), implode('; ', $req)
		)));
	}
	
	/* exec () -    */
	public function exec()
	{
		$cp = count($this->points);
		
		if ($cp == 0) 
		{
			return false;
		}
		elseif ($cp == 1)
		{
			$ch = curl_init(); $point_name = $this->points[0]; $ps = $this->$point_name->params;
			if ($ps) {foreach ($ps as $k=>$v) curl_setopt($ch, $this->join_option($k), $v);
			$data = curl_exec($ch);} curl_close($ch); if (!$this->$point_name->s) unset($this->$point_name);
			return $data;
		}
		else
		{
			$index = 0; $channels = array(); $return_array = array();
			foreach ($this->points as $point_name)
			{
				$index++; $chname = 'ch'.$index; $$chname = curl_init(); $ps = $this->$point_name->params;
				foreach ($ps as $k=>$v) curl_setopt($$chname, $this->join_option($k), $v);
				if (!$this->$point_name->s) {unset($this->$point_name);} $channels[] = $chname;
			}
			
			$mh = curl_multi_init();
			
			foreach ($channels as $chof)
			{
				curl_multi_add_handle($mh, $$chof);
			}
			
			$active = null;
			
			do {
				$mrc = curl_multi_exec($mh, $active);
			} while ($mrc == CURLM_CALL_MULTI_PERFORM);

			while ($active && $mrc == CURLM_OK) {
				if (curl_multi_select($mh) != -1) {
					do {
						$mrc = curl_multi_exec($mh, $active);
					} while ($mrc == CURLM_CALL_MULTI_PERFORM);
				}
			}
			
			foreach ($channels as $chof)
			{
				$content = curl_multi_getcontent($$chof);
				if (!empty($content)) $return_array[] = $content;
				curl_multi_remove_handle($mh, $$chof);
			}
			
			curl_multi_close($mh);
			
			return $return_array;
		}
	}
	
	public function __invoke()
	{
		return $this->exec();
	}
}

class curlpoint
{
	public $params = array();
	public $s = false;
	
	public function __construct($pdata)
	{
		$pdata['header']?:$pdata['header']=0;
		$pdata['returntransfer']?:$pdata['returntransfer']=1;
		$this->set($pdata);
	}
	
	public function __set($name, $value)
	{
		if ($name !== 's') $this->params[$name] = $value;
	}
	
	public function set($pdata)
	{
		foreach ($pdata as $key => $value)
		 {
			 $this->$key = $value;
		 }
		return $this;
	}
	
	public function secure($key=true)
	{
		$this->s = $key;
		return $this;
	}
	
}