<?php

class Registry
{
    public static $session;
    public static $flash;

    public static function init($flashKey = '@flash')
    {
        if (isset(self::$flash)) { return; }
        session_start();
        self::$session =& $_SESSION;
        self::$flash = new FlashArray($flashKey);
    }
}

class FlashArray implements ArrayAccess
{
    private $_root;
    private $_access;

    public function __construct($flashKey)
    {
        $this->_root = $flashKey;
        $this->_access = array();
    }

    public function __destruct()
    {
        foreach ($this->_access as $key => $val) {
            if ($val) {
                unset(Registry::$session[$this->_root][$key]);
            }
        }
    }

    public function offsetSet($offset, $value) 
    {
        if (is_null($offset)) {
            Registry::$session[$this->_root][] = $value;
            // get new offset
            end(Registry::$session[$this->_root]);
            $offset = key(Registry::$session[$this->_root]);
        } else {
            Registry::$session[$this->_root][$offset] = $value;
        }
        $this->_access[$offset] = 0; // mark to NOT delete
    }

    public function offsetExists($offset)
    {
        return isset(Registry::$session[$this->_root][$offset]);
    }

    public function offsetUnset($offset)
    {
        unset(Registry::$session[$this->_root][$offset]);
    }

    public function offsetGet($offset)
    {
        if (!isset($this->_access[$offset])) {
            $this->_access[$offset] = 1; // mark to delete
        }
        return isset(Registry::$session[$this->_root][$offset]) ? Registry::$session[$this->_root][$offset] : NULL;
    }
}

// ------------------------------------------

Registry::init();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST['reset'])) {
        session_destroy();
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }

    $name  = isset($_POST['name'])  ? $_POST['name']  : '';
    $value = isset($_POST['value']) ? $_POST['value'] : '';

    if (strlen($name) == 0) {
        echo '<p style="color: #e33;">*** Name is empty. I did nothing!</p>';
    } else {

        if (empty($_POST['is_flash'])) {
            $ref =& Registry::$session;
        } else {
            $ref =& Registry::$flash;
        }

        if (isset($_POST['set'])) {
            $ref[$name] = $value;
        }
        if (isset($_POST['get'])) {
            if (isset($ref[$name])) {
                $value = $ref[$name];
                echo '<p>' . $name . ' = "' . htmlspecialchars($value) . '"</p>';
            } else {
                echo '<p>' . $name . ' is not set</p>';
            }
            echo '<p><a href="' . $_SERVER['PHP_SELF'] . '">Click to continue</a></p>';
            exit;
        }
        if (isset($_POST['del'])) {
            unset($ref[$name]);
        }
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }
}

echo '<pre>'.htmlspecialchars(var_export(Registry::$session, TRUE)).'</pre><hr/>';

?>

<form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
<fieldset><legend>Session variable</legend>

    <div style="float: left; width: 200px;">
        <strong>Name<sup>*</sup>:</strong><br/>
        <input name="name" type="text" value=""/>
    </div>

    <div style="margin-left: 200px;">
        <strong>Value:</strong><br/>
        <input name="value" type="text" value=""/>
    </div>

    <div style="clear: both;">
        <label><input name="is_flash" type="checkbox" value="1"/> Is flash variable</label>

</fieldset>

<p>
    <input type="submit" name="set" value=" Set " />
    <input type="submit" name="get" value=" Get " />
    <input type="submit" name="del" value=" Del " />
</p>
<p>
    OR <input type="submit" name="reset" value=" Start new session " />
</p>
</form>