function dump(varval, varname)
{
  var text = '';
  var padding = '';

  if (typeof(dump.level) == 'undefined') dump.level = 0;
  dump.level++;
  for(var j = 1; j < dump.level; j++) padding += '  ';

  text = padding;
  if (typeof(varname) != 'undefined') {
    text += '"' + varname + '"' + ': ';
  }

  if (typeof(varval) == 'object') {
    text += '{\n';
    for (var key in varval) {
      var val = varval[key];
      text += dump(val, key);
    }
    text += padding + '},\n';
  } else {
    text += '"' + varval + '"' + ',\n';
  }

  dump.level--;
  return text;
}
