<?php

class App
{
	public 
		$start,
		$debugFile;

	function __construct()
	{
		$this->start = microtime(TRUE);
		$this->debugFile = 'js/debug/' . $this->start . '.js';
	}

	function __destruct()
	{
		$now = microtime(TRUE);
		$debugInfo = array(
			'start'    => date('r', $this->start),
			'execTime' => sprintf('%.4f sec', ($now - $this->start)),
			'method'   => $_SERVER['REQUEST_METHOD'],
			'uri'      => $_SERVER['REQUEST_URI'],
			'memUse'   => $this->fileSize(memory_get_usage()),
			'memMaxUse'=> $this->fileSize(memory_get_peak_usage()),
			'log'      => Log::get(), // whole log entries
		);
		$debugInfo = 'var debugInfo = ' . json_encode($debugInfo) . ';';
		file_put_contents(dirname(__FILE__) . '/' . $this->debugFile, $debugInfo);
	}

	private
		$units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB');

	function fileSize($size)
	{
		for ($i = 0; $size > 1024; $i++) {
			$size /= 1024;
		}
		return round($size, 2).' '.$this->units[$i];
	}

}

class Log
{
	private static
		$_log = array();

    const
    	EMERG   = 0,  // Emergency: system is unusable
    	ALERT   = 1,  // Alert: action must be taken immediately
    	CRIT    = 2,  // Critical: critical conditions
    	ERR     = 3,  // Error: error conditions
    	WARN    = 4,  // Warning: warning conditions
    	NOTICE  = 5,  // Notice: normal but significant condition
    	INFO    = 6,  // Informational: informational messages
    	DEBUG   = 7;  // Debug: debug messages

	public static function add($data, $priority = self::DEBUG)
	{
		self::$_log[] = array(microtime(TRUE), $data, $priority);
	}

	public static function get($filter = NULL)
	{
		if (is_null($filter)) {
			$ret = self::$_log;
		} else if (is_array($filter)) {
			$ret = array();
			foreach (self::$_log as $event) {
				if (in_array($event[2], $filter)) {
					$ret[] = $event;
				}
			}
		} else {
			$ret = array();
			foreach (self::$_log as $event) {
				if ($event[2] <= $filter) {
					$ret[] = $event;
				}
			}
		}
		return $ret;
	}
}

//----------------------------------

$app = new App();

Log::add('lorem ipsum');

// Output

?>

<h1>Blablabla</h1>

<script type="text/javascript" src="js/dump.js"></script>
<script type="text/javascript" src="<?php echo $app->debugFile ?>"></script>

<pre><script type="text/javascript">
document.write(dump(debugInfo));
</script></pre>

<?php

// my time lag
for ($i = 0; $i < 1000000; ++$i) { }
Log::add('semper ut egestas');
