<?php

class QbView extends QbComponent
{
    private
        $_parents = array(),
        $_names   = array(),
        $_blocks  = array();

    public function render($viewId, $data = array())
    {
        extract($data);
        include $this->_template($viewId);
        while (!empty($this->_parents)) {
            $this->_grab('content');
            extract($this->_blocks);
            include $this->_template(array_pop($this->_parents));
        }
    }

	protected function _template($viewId)
	{
		return 'templates/' . $viewId . '.php';
	}

    private function _extends($viewId)
    {
        array_push($this->_parents, $viewId);
        ob_start();
    }

    private function _blockBegin($block)
    {
        array_push($this->_names, $block);
        ob_start();
    }

    private function _blockEnd()
    {
        $this->_grab(array_pop($this->_names));
    }

    private function _grab($block)
    {
		// Do not override existing blocks
        if (isset($this->_blocks[$block])) {
            ob_end_clean();
            return;
        }
        $buf = ob_get_clean();
        if (strlen(trim($buf)) > 0) {
            $this->_blocks[$block] = $buf;
        }
    }

    public function e($s)
    {
    	return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
	}
}
