<?php

class QbImageView extends QbFileBackend
{
	public
		$quality = 80, // for jpeg: 0..100, for png: 0..9
		$id,
		$idLength = 9,
		$type     = 'image/jpeg',
		$sizes    = array(),
		$size     = 'sq',
		$targetDir,
		$dirMode = 0777,
		$fastAndDirty = FALSE,
		$typeByExt = array(),
		$targetFileRule = '{$targetDir}{$sizeDir}/{$id:0,3}/{$id:3,3}/{$id:6,3}.{$ext}';

	public function set($paramName, $paramValue)
	{
		$this->$paramName = $paramValue;
		return $this;
	}

    protected
    	$_image, $_w, $_h;

    public function validate()
    {
        if(!is_resource($this->_image))
        {
            throw new QbException('No image loaded');
        }
        return $this;
    }

    function load($filename)
    {
        if(!is_file($filename)){
            throw new QbException('File does not exist');
		}
        if (!($data = @getimagesize($filename))) {
            throw new QbException('File is not image');
        }
        list($this->_w, $this->_h) = $data;
	    if (($type = $data['mime']) == 'image/pjpeg') {
    	    $type = 'image/jpeg';
	    }
	    $func = 'imagecreatefrom' . substr($type, 6);
    	if( !function_exists($func)) {
        	throw new QbException('Function ' . $func . ' is unavailable');
	    }
		if (isset($this->_image)) {
			imagedestroy($this->_image);
		}
        $this->_image = $func($filename);
        return $this;
    }

	public function resize($size)
	{
		$this->size = $size;
		list($width, $height, $crop) = $this->sizes[$size];
		return $crop ?
			$this->resizeCrop($width, $height) :
			$this->resizeFit($width, $height);
	}

	public function resizeCrop($maxWidth, $maxHeight)
	{
		$this->validate();
	    $ratioX = $this->_w / $maxWidth;
	    $ratioY = $this->_h / $maxHeight;
	   	$dX = $dY = 0;
		if ($ratioX < $ratioY) {
			$dY = round(($this->_h - ($tmp = $maxHeight * $ratioX)) / 2);
			$this->_h = $tmp;
		} else {
			$dX = round(($this->_w - ($tmp = $maxWidth * $ratioY)) / 2);
			$this->_w = $tmp;
		}
	    $copy = imagecreatetruecolor($maxWidth, $maxHeight);
		if ($this->fastAndDirty) {
		    imagecopyresized($copy, $this->_image, 0, 0, $dX, $dY, $maxWidth, $maxHeight, $this->_w, $this->_h);
		} else {
		    imagecopyresampled($copy, $this->_image, 0, 0, $dX, $dY, $maxWidth, $maxHeight, $this->_w, $this->_h);
		}
	    imagedestroy($this->_image);
	    $this->_image = $copy;
	    $this->_w = $maxWidth;
	    $this->_h = $maxHeight;
		return $this;
	}

	public function resizeFit($maxWidth, $maxHeight)
	{
		$this->validate();
	    $ratio = max($this->_w / $maxWidth, $this->_h / $maxHeight);
	    $newWidth = round($this->_w / $ratio);
	    $newHeight = round($this->_h / $ratio);
	    $copy = imagecreatetruecolor($newWidth, $newHeight);
		if ($this->fastAndDirty) {
		    imagecopyresized($copy, $this->_image, 0, 0, 0, 0, $newWidth, $newHeight, $this->_w, $this->_h);
		} else {
		    imagecopyresampled($copy, $this->_image, 0, 0, 0, 0, $newWidth, $newHeight, $this->_w, $this->_h);
		}
	    imagedestroy($this->_image);
	    $this->_image = $copy;
	    $this->_w = $newWidth;
	    $this->_h = $newHeight;
		return $this;
	}

	public function blur()
	{
		$this->validate();
		$gaussianMatrix = array(array(1, 2, 1), array(2, 4, 2), array(1, 2, 1));
		imageconvolution($this->_image, $gaussianMatrix, 16, 0);
		return $this;
	}

	public function sharp()
	{
		$this->validate();
		$sharpenMatrix = array(array(-1, -1, -1), array(-1, 16, -1), array(-1, -1, -1));
		imageconvolution($this->_image, $sharpenMatrix, 8, 0);
		return $this;
	}

	public function grayscale()
	{
		$this->validate();
		imagefilter($this->_image, IMG_FILTER_GRAYSCALE);
		return $this;
	}

	public function sepia()
	{
		$this->validate();
		imagefilter($this->_image, IMG_FILTER_GRAYSCALE);
		imagefilter($this->_image, IMG_FILTER_COLORIZE, 90, 60, 40);
		return $this;
	}

	public function save()
	{
		return $this->saveTo($this->targetName());
	}

    public function saveTo($fileName)
    {
		$this->validate();
		if (is_null($fileName)) {
		    $this->type = 'image/jpeg';
		} else {
			@mkdir(dirname($fileName), $this->dirMode, TRUE);
			$this->type = $this->filenameToType($fileName);
		}
		$func = 'image' . substr($this->type, 6);
    	if( !function_exists($func)) {
        	throw new QbException('Function ' . $func . ' is unavailable');
	    }
		$func($this->_image, $fileName, $this->quality);
		return $this;
    }

    public function show()
    {
    	header('Content-type: image/jpeg');
    	return $this->saveTo(NULL);
    }

	public function free()
	{
        if(is_resource($this->_image)) {
	   	    imagedestroy($this->_image);
	   	    unset($this->_image);
	   	}
	   	return $this;
	}

	public function targetName()
	{
		if (!isset($this->targetFileRule)) {
			throw new QbException('Cannot generate file name');
		}
		// Set common used parameters
		$this->id      = str_pad($this->id, $this->idLength, '0', STR_PAD_LEFT);
		$this->ext     = $this->typeToExt($this->type);
		$this->sizeDir = $this->size;
		return $this->buildString($this->targetFileRule);
	}
}
