<?php

class QbFileStorage extends QbFileBackend
{
	public
		// These options can be overriden by constructor parameters
		$uploadDir = './upload/',
		$targetFileRule = '{$uploadDir}{$hash:0,3}/{$hash:3,3}/{$hash:6,3}.dat',
		$acceptTypes = array(),
		$dirMode = 0777,
		$maxFileSize = 0,
		$maxImageSize = array(),
		$overwriteExisting = FALSE;

	public function upload($fileVarName, $subject = '')
	{
		$this->_records = array();
		$this->_subject = $subject;
		$this->_uploaded = time();

		$this->_errors = array();
		if(empty($_FILES[$fileVarName]['name'])) {
			return 0;
		}
		// NOTE: we'll ignore 'type' and 'size' given by browser
		// <input name="attach[]" ... />
		if (is_array($_FILES[$fileVarName]['name'])) {
			$v =& $_FILES[$fileVarName];
			foreach ($_FILES[$fileVarName]['name'] as $id => $name) {
				if (strlen($name) == 0) {
					continue;
				}
				$this->_getOneUploaded($v['name'][$id],
				                       $v['tmp_name'][$id],
				                       $v['error'][$id]);
			}
		// <input name="attach" ... />
		} else {
			$v =& $_FILES[$fileVarName];
			if (strlen($v['name']) > 0) {
				$this->_getOneUploaded($v['name'],
				                       $v['tmp_name'],
				                       $v['error']);
			}
		}
		return count($this->_records);
	}

	public function download($record, $disposition = 'attachment')
	{
		header('Content-type: ' . $record['type']);
		header('Content-Disposition: ' . $disposition . '; filename="' . htmlspecialchars($record['name'], ENT_QUOTES) . '"');
		readfile($record['target']);
	}

	public function delete($record)
	{
		@unlink($record['target']);
	}

	private
		$_records,
		$_errors,
		$_subject,
		$_uploaded;

	private function _getOneUploaded($name, $tmpName, $error)
	{
		$e = $target = NULL;
		$size = filesize($tmpName);
		if (!empty($this->maxFileSize) && $size > $this->maxFileSize) {
			$error = UPLOAD_ERR_FORM_SIZE;
		}
		switch ($error) {
			case UPLOAD_ERR_OK:
				$type = $this->filenameToType($name);
				if (!empty($this->acceptTypes) && !in_array($type, $this->acceptTypes)) {
					$e = 'Restricted file type';
				} else if (strpos($type, 'image/') === 0 && !empty($this->maxImageSize)) {
					$imageSize = getimagesize($tmpName);
					if ($imageSize[0] > $this->maxImageSize[0] || $imageSize[1] > $this->maxImageSize[1]) {
						$e = 'Image exceeds bounds';
					}
				}
				if (empty($e)) {
					$target = $this->targetName();
					@mkdir(dirname($target), $this->dirMode, TRUE);
					if(!@move_uploaded_file($tmpName, $target)) {
						$e = 'No file was uploaded';
					}
				}
				break;
			case UPLOAD_ERR_INI_SIZE:
				$e = 'File exceeds upload_max_filesize';
				break;
			case UPLOAD_ERR_FORM_SIZE:
				$e = 'File exceeds MAX_FILE_SIZE';
				break;
			case UPLOAD_ERR_PARTIAL:
				$e = 'File was only partially uploaded';
				break;
			case UPLOAD_ERR_NO_FILE:
				$e = 'No file was uploaded';
				break;
			default:
				$e = 'Unknown file upload error';
		}
		if (is_null($e)) {
			$record = array(
				'type'     => $type,
				'target'   => $target,
				'name'     => $name,
				'size'     => $size,
				'subject'  => $this->_subject,
				'uploaded' => $this->_uploaded);
			$e = $this->notify('onUpload', $record);
		}
		if (is_null($e)) {
			$this->_records[] = $record;
		} else {
			if (isset($target)) {
				@unlink($target);
			}
			$this->_errors[] = $e;
		}
	}

	public function getUploadedNumber()
	{
		return count($this->_records);
	}

	public function getRecords()
	{
		return $this->_records;
	}

	public function getErrors()
	{
		return $this->_errors;
	}

	public function targetName()
	{
		$n = isset($this->hashLength) ? $this->hashLength : 16;
		$rule = $this->targetFileRule;
		do {
			$this->hash = $this->buildHash($n);
			$ret = $this->buildString($rule);
		} while(!$this->overwriteExisting && file_exists($ret));
		return $ret;
	}
}