<?php

abstract class QbFileBackend extends QbComponent
{
	protected
		$typeByExt   = array(),
		$defaultType = 'application/octet-stream',
		$hashChars   = 'abcdef0123456789';

	public function buildHash($len)
	{
		$chars = $this->hashChars;
		$n = strlen($chars);
		for ($ret = '', $i = 0; $i < $len; ++$i) {
			$ret .= substr($chars, (mt_rand() % $n), 1);
		}
		return $ret;
	}

	public function filenameToType($fileName)
	{
		$ext = strtolower(substr($fileName, strrpos($fileName, '.') + 1));
		if (!empty($ext) && isset($this->typeByExt[$ext])) {
			$type = $this->typeByExt[$ext];
		} else if (function_exists('mime_content_type')) {
			$type = mime_content_type($fileName); // NOTE: can be FALSE
		}
		return empty($type) ? $this->defaultType : $type;
	}

	public function typeToExt()
	{
		return array_search($this->type, $this->typeByExt);
	}

	abstract public function targetName();
}