<?php

error_reporting(-1);

require './lib/qbcore.php';
Qb::useConfig(require('./config/main.php'));

$action = isset($_GET['action']) ? $_GET['action'] : 'list';

if ($action != 'download') {
	header('Content-type: text/html; charset=utf-8');
	$pageTitle = 'artoodetoo uploader';
}

switch ($action) {

case 'add':
	$pageTitle .= ' :: Add new files';
	$maxFileSize = Qb::get('maxFileSize');
	$baseUrl = Qb::get('baseUrl');
	Qb::c('view')->render('addform', compact('pageTitle', 'baseUrl', 'maxFileSize'));
	break;

case 'addpost':
	$pageTitle .= ' :: Files added';
	$subject = isset($_POST['subject']) ? $_POST['subject'] : '';
	$storage = Qb::c('storage');
	$num = $storage->upload('attach', $subject);
	$errors = $storage->getErrors();
	$newRecords = array();
	if ($num) {
		$manager = Qb::c('recordManager');
		$it = $manager->getIterator();
		foreach ($storage->getRecords() as $rec) {
			$it->append($rec);
			$id = $manager->lastKey();
			$newRecords[$id] = $rec;
		}
		$manager->close();
	}
	Qb::c('view')->render('afteradd', compact('pageTitle', 'baseUrl', 'subject', 'num', 'errors', 'newRecords'));
	break;

case 'download':
	$id = isset($_GET['id']) ? intval($_GET['id']) : NULL;
	$manager = Qb::c('recordManager');
	$it = $manager->getIterator();
	if ($it->valid($id)) {
		$rec = $it->offsetGet($id);
		$storage = Qb::c('storage');
		$storage->download($rec);
	} else {
		header ('HTTP/1.0 404 Not Found');
		exit('404 File not found');
	}
	break;

case 'preview':
	$id = isset($_GET['id']) ? intval($_GET['id']) : NULL;
	$size = isset($_GET['size']) ? $_GET['size'] : 'sq';
	$baseUrl = Qb::get('baseUrl');
	$manager = Qb::c('recordManager');
	$it = $manager->getIterator();
	if ($it->valid($id)) {
		$rec = $it->offsetGet($id);
		if (strpos($rec['type'], 'image/') !== 0) {
			die('File is not image');
		}
		$sizes = Qb::get('previews');
		$ref = Qb::c('preview')
		  ->set('id', $id)
		  ->set('size', $size)
		  ->targetName();
	} else {
		header ('HTTP/1.0 404 Not Found');
		exit('404 File not found');
	}
	Qb::c('view')->render('preview', compact('pageTitle', 'baseUrl', 'id', 'ref', 'sizes'));
	break;

case 'delete':
	$id = isset($_GET['id']) ? intval($_GET['id']) : NULL;
	$manager = Qb::c('recordManager');
	$it = $manager->getIterator();
	if ($it->valid($id)) {
		$rec = $it->offsetGet($id);
		if (isset($_POST['del_comply'])) {
			Qb::c('storage')->delete($rec);
			$it->offsetUnset($id);
			$manager->close();
		} else {
			$pageTitle .= ' :: Confirm delete';
			$name = $rec['name'];
			Qb::c('view')->render('confirmdelete', compact('pageTitle', 'baseUrl', 'id', 'name'));
			break;
		}
	} else {
		header ('HTTP/1.0 404 Not Found');
		exit('404 File not found');
	}
	header('Location: index.php?action=list');
	break;

case 'list':
	$pageTitle .= ' :: List files';
	$manager = Qb::c('recordManager');
	$it = $manager->getIterator();
	Qb::c('view')->render('list', compact('pageTitle', 'baseUrl', 'it'));
	break;
}