<?php

return array(

'classes' => array('*' => './lib/'),

'components' => array(
	'view' => array(
		'class' => 'QbView',
		'@templateDir'  => 'templateDir'),
	'recordManager' => array(
		'class'         => 'QbFileRecordManager',
		'@uploadDir'    => 'uploadDir'),
	'storage' => array(
		'class'         => 'QbFileStorage', 
		'@maxFileSize'  => 'maxFileSize',
		'@maxImageSize' => 'maxImageSize',
		'@uploadDir'    => 'uploadDir',
		'@typeByExt'    => 'mime', 
		'@acceptTypes'  => 'acceptTypes'),
	'preview' => array(
		'class'         => 'QbImageView', 
		'@typeByExt'    => 'mime', 
		'@sizes'        => 'previews',
		'@targetDir'    => 'thumbDir'),
),

'baseUrl'     => 'http://plugins.test1.ru/',
'maxFileSize' => 20480000,
'maxImageSize' => array(1024, 1024),

'uploadDir'   => './upload/',
'thumbDir'    => './thumb/',
'templateDir' => './templates/',

'acceptTypes' => array(
	'image/jpeg', 
	'image/gif', 
	'image/png', 
	'text/plain', 
	'text/html', 
	'application/zip'),

'previews' => array(
	'sq'  => array(75,   75,  TRUE,  'square'   ),
	't'   => array(100,  100, FALSE, 'thumbnail'),
	's'   => array(240,  240, FALSE, 'small'    ),
	'm'   => array(500,  500, FALSE, 'medium500'),
	'z'   => array(640,  640, FALSE, 'medium640'),
	'l'   => array(1024, 1024,FALSE, 'large'    ),
),

'mime' => array(
	'avi'   => 'video/avi',
	'bmp'   => 'image/bmp',
	'flv'   => 'video/x-flv',
	'gif'   => 'image/gif',
	'gtar'  => 'application/x-gtar',
	'gz'    => 'application/x-gzip',
	'htm'   => 'text/html',
	'html'  => 'text/html',
	'jar'   => 'application/java-archive',
	'java'  => 'application/x-java-applet',
	'jpg'   => 'image/jpeg',
	'jpeg'  => 'image/jpeg',
	'jpe'   => 'image/jpeg',
	'jfif'  => 'image/jpeg',
	'js'    => 'application/x-javascript',
	'midi'  => 'audio/midi',
	'mid'   => 'audio/midi',
	'mov'   => 'video/quicktime',
	'mp3'   => 'audio/mpeg',
	'mp4'   => 'audio/mp4',
	'mpa'   => 'video/mpeg',
	'mpe'   => 'video/mpeg',
	'mpeg'  => 'video/mpeg',
	'mpg'   => 'video/mpeg',
	'mpg4'  => 'video/mp4',
	'mpga'  => 'audio/mpeg',
	'pdf'   => 'application/pdf',
	'png'   => 'image/png',
	'qt'    => 'video/quicktime',
	'ra'    => 'audio/x-realaudio',
	'ram'   => 'audio/x-realaudio',
	'rar'   => 'application/rar',
	'rgb'   => 'image/x-rgb',
	'rm'    => 'audio/x-pn-realaudio',
	'rtf'   => 'text/rtf',
	'swf'   => 'application/x-shockwave-flash',
	'tar'   => 'application/x-tar',
	'text'  => 'text/plain',
	'tgz'   => 'application/x-tar',
	'tif'   => 'image/tiff',
	'tiff'  => 'image/tiff',
	'txt'   => 'text/plain',
	'wav'   => 'audio/x-wav',
	'z'     => 'application/x-compress',
	'zip'   => 'application/zip',
),

);
