<?php
######################################################################
# CusCounter 3: Customer Counter
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: cuscounter.php
# Version: 3.1.3
######################################################################

ini_set ("display_errors", 0);
@ini_set ("session.use_trans_sid", true);

@session_start ();

require_once ("config/constants.php");
require_once ("config/mysql.php");

require_once ("class/cc_visit.php");
require_once ("class/cc_db.php");
require_once ("class/cc_error.php");
require_once ("class/cc_ban.php");

$cc_db = new cc_db (CC_DB_HOST, CC_DB_USER, CC_DB_PASS, CC_DB_NAME);
$cc_error = new cc_error;

$cc_ban = new cc_ban (NULL, $_SERVER['REMOTE_ADDR']);
$cc_ban->acces ($cc_db);

$cc_visit = new cc_visit ($_SERVER['REMOTE_ADDR'], gethostbyaddr($_SERVER['REMOTE_ADDR']), date ("Y-m-d H:i:s"), @$_SERVER['HTTP_REFERER']);

$inifile_name = "cuscounter/config/cuscounter.ini";
if (!file_exists ($inifile_name))
	$cc_error->error ("  !");

$settings = parse_ini_file ($inifile_name);
if ((!isset ($settings['file_version'])) || (!isset ($settings['counter_on'])) || (!isset ($settings['refresh_log'])) || (!isset ($settings['diapasone_log'])) || (!isset ($settings['print_settings'])))
	$cc_error->error ("   !");

if ($settings['counter_on'])
{
	if (!isset ($_SESSION['refresh']))
	{
		if (!$cc_visit->search_bot ($cc_db, $cc_error))
		switch ($settings['diapasone_log'])
		{
			case 0: $cc_visit->add ($cc_db);
			break;
			
			case 1:
			{
				$cc_it_set = $cc_db->result_count (CC_VISIT, '`date` BETWEEN "'.date("Y-m-d").' 00:00:01" AND "'.date("Y-m-d").' 23:59:59" AND `ip`="'.$_SERVER['REMOTE_ADDR'].'" LIMIT 1');
				if ($cc_it_set == 0)
					$cc_visit->add ($cc_db);
			}
			break;
			
			case 2:
			{
				$cc_it_set = $cc_db->result_count (CC_VISIT, '`ip`="'.$_SERVER['REMOTE_ADDR'].'" LIMIT 1');
				if ($cc_it_set == 0)
					$cc_visit->add ($cc_db);
			}
			break;
			
			default: $cc_error->error ("   !");
		}
		if ($settings['refresh_log'] == 0)
			$_SESSION['refresh'] = 1;
	}
	if ($settings['print_settings'] == 1)
	{
		$g_day = date ("d");
		$g_month = date ("m");
		$g_year = date ("Y");
		
		$all_visits = $cc_visit->all_visits ($cc_db);
		$today_visits = $cc_visit->today_visits ($cc_db);
		$month_visits = $cc_visit->month_visits ($cc_db, $g_month, $g_year);
		$year_visits = $cc_visit->year_visits ($cc_db, $g_year);
		$unik_day_visits = $cc_visit->unik_day_visits ($cc_db, $g_day, $g_month, $g_year);
		$unik_month_visits = $cc_visit->unik_month_visits ($cc_db, $g_month, $g_year);
		$unik_year_visits = $cc_visit->unik_year_visits ($cc_db, $g_year);
		
		require_once ("config/print.php");
	}
}

?>