<?php
######################################################################
# CusCounter 3: Customer Counter
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: cc_visit.php
# Version: 3.1.3
######################################################################

class cc_visit 
{
	private $id;
	private $ip;
	private $host;
	private $date;
	private $referer;
	
	public function __construct ($ip = NULL, $host = NULL, $date = NULL, $referer = NULL, $id = NULL)
	{
		$this->ip = $ip;
		$this->host = $host;
		$this->date = $date;
		$this->referer = $referer;
		$this->id = $id;
	}
	
	public function add (cc_db $cc_db)
	{
		$cc_db->sql_query ('INSERT INTO `'.CC_VISIT.'` (`ip`, `host`, `date`, `referer`) VALUES ("'.$this->ip.'", "'.$this->host.'", "'.$this->date.'", "'.$this->referer.'")');
	}
	
	public function delete (cc_db $cc_db, $id)
	{
		$this->id = $cc_db->escape_string ($id);
		$cc_db->sql_query ('DELETE FROM `'.CC_VISIT.'` WHERE `id`='.$this->id.' LIMIT 1');
	}
	
	public function all_visits (cc_db $cc_db)
	{
		return $cc_db->result_count (CC_VISIT);
	}
	
	public function today_visits (cc_db $cc_db)
	{
		return $cc_db->result_count (CC_VISIT, '`date` BETWEEN "'.date("Y-m-d").' 00:00:01" AND "'.date("Y-m-d").' 23:59:59"');
	}
	
	public function day_visits (cc_db $cc_db, $nday, $nmonth, $nyear)
	{
		return $cc_db->result_count (CC_VISIT, '`date` BETWEEN "'.$nyear.'-'.$nmonth.'-'.$nday.' 00:00:01" AND "'.$nyear."-".$nmonth."-".$nday.' 23:59:59"');
	}
	
	public function year_visits (cc_db $cc_db, $nyear)
	{
		return $cc_db->result_count (CC_VISIT, '`date` BETWEEN "'.$nyear.'-01-01 00:00:01" AND "'.$nyear.'-12-31 23:59:59"');
	}
	
	public function month_visits (cc_db $cc_db, $nmonth, $nyear)
	{
		return $cc_db->result_count (CC_VISIT, '`date` BETWEEN "'.$nyear.'-'.$nmonth.'-01 00:00:01" AND "'.$nyear.'-'.$nmonth.'-31 23:59:59"');
	}
	
	public function unik_all_visits (cc_db $cc_db)
	{
		$cc_db->sql_query ('SELECT DISTINCT `ip` FROM '.CC_VISIT);
		for ($i = 0; $cc_db->fetchrow (); $i++) { }
		return $i;
	}
	
	public function unik_day_visits (cc_db $cc_db, $nday, $nmonth, $nyear)
	{
		$cc_db->sql_query ('SELECT DISTINCT `ip` FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.$nyear.'-'.$nmonth.'-'.$nday.' 00:00:01" AND "'.$nyear."-".$nmonth."-".$nday.' 23:59:59"');
		for ($i = 0; $cc_db->fetchrow (); $i++) { }
		return $i;
	}
	
	public function unik_year_visits (cc_db $cc_db, $nyear)
	{
		$cc_db->sql_query ('SELECT DISTINCT `ip` FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.$nyear.'-01-01 00:00:01" AND "'.$nyear.'-12-31 23:59:59"');
		for ($i = 0; $cc_db->fetchrow (); $i++) { }
		return $i;
	}
	
	public function unik_month_visits (cc_db $cc_db, $nmonth, $nyear)
	{
		$cc_db->sql_query ('SELECT DISTINCT `ip` FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.$nyear.'-'.$nmonth.'-01 00:00:01" AND "'.$nyear.'-'.$nmonth.'-31 23:59:59"');
		for ($i = 0; $cc_db->fetchrow (); $i++) { }
		return $i;
	}
	
	public function complete_select (cc_db $cc_db, $year = NULL, $month = NULL, $day = NULL)
	{
		if ($year ==  NULL)
			$cc_db->sql_query ('SELECT * FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.date("Y-m-d").' 00:00:01" AND "'.date("Y-m-d").' 23:59:59"');
		elseif ($month == NULL)
			$cc_db->sql_query ('SELECT * FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.$year.'-01-01 00:00:01" AND "'.$year.'-12-31 23:59:59"');
		elseif ($day == NULL)
			$cc_db->sql_query ('SELECT* FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.$year.'-'.$month.'-01 00:00:01" AND "'.$year.'-'.$month.'-31 23:59:59"');
		else
			$cc_db->sql_query ('SELECT * FROM '.CC_VISIT.' WHERE `date` BETWEEN "'.$year.'-'.$month.'-'.$day.' 00:00:01" AND "'.$year."-".$month."-".$day.' 23:59:59"');

		return $cc_db->result_to_array ();
	}
	
	public function search_bot (cc_db $cc_db, cc_error $cc_error)
	{
		$botsfile = "cuscounter/config/search_bot.ini";
		if (!file_exists ($botsfile))
			$cc_error->error ("    !");
		$bots = parse_ini_file ($botsfile);
		if ($bots['bot_google'])
			if (strpos ($this->host, 'googlebot.com') !== false)
				return true;
		if ($bots['bot_yandex'])
			if (strpos ($this->host, 'yandex.ru') !== false)
				return true;
		if ($bots['bot_yahoo'])
			if (strpos ($this->host, 'yahoo.net') !== false)
				return true;
		if ($bots['bot_rambler'])
			if (strpos ($this->host, 'rambler.ru') !== false)
				return true;
		if ($bots['bot_msn'])
			if (strpos ($this->host, 'msn.com') !== false)
				return true;
		if ($bots['bot_livesearch'])
			if (strpos ($this->host, 'search.live.com') !== false)
				return true;
		if ($bots['bot_webalta'])
			if (strpos ($this->ip, '77.91.224') !== false)
				return true;
				
		return false;
	}
}

?>