<?php
######################################################################
# CusCounter 3: Customer Counter
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: cc_calendar.php
# Version: 3.1.3
######################################################################

class cc_calendar
{
	var $y;
	var $m;
	var $d;
	var $h;
	var $min;
	var $s;
	
	var $month = array();
	
	var $table;
	
	function __construct ($date)
	{
		$this->y = substr ($date, 0, 4);
		$this->m = substr ($date, 5, 2);
		$this->d = substr ($date, 8, 2);
		$this->h = substr ($date, 11, 2);
		$this->min = substr ($date, 14, 2);
		$this->s = substr ($date, 17, 2);
	}
	
	function get_str_month (cc_calendar $cc_now)
	{
		switch ($this->m)
		{
			case 1: $str_m = "ѳ";
			break;
			
			case 2: $str_m = "";
			break;
			
			case 3: $str_m = "";
			break;
			
			case 4:	$str_m = "";
			break;
			
			case 5: $str_m = "";
			break;
			
			case 6: $str_m = "";
			break;
			
			case 7: $str_m = "";
			break;
			
			case 8: $str_m = "";
			break;
			
			case 9: $str_m = "";
			break;
			
			case 10: $str_m = "";
			break;
			
			case 11: $str_m = "";
			break;
			
			case 12: $str_m = "";
			break;
		}
		
		return $str_m;
	}
	
	function get_str_month_p (cc_calendar $cc_now)
	{
		switch ($this->m)
		{
			case 1: $str_m = "";
			break;
			
			case 2: $str_m = "";
			break;
			
			case 3: $str_m = "";
			break;
			
			case 4: $str_m = "";
			break;
			
			case 5: $str_m = "";
			break;
			
			case 6: $str_m = "";
			break;
			
			case 7: $str_m = "";
			break;
			
			case 8: $str_m = "";
			break;
			
			case 9:	$str_m = "";
			break;
			
			case 10: $str_m = "";
			break;
			
			case 11: $str_m = "";
			break;
			
			case 12: $str_m = "";
			break;
		}
		
		return $str_m;
	}
	
	function get_wday (cc_calendar $cc_now)
	{
		$wday = @jddayofweek (gregoriantojd ($this->m, 1, $this->y), 0);
		return $wday;
	}
	
	function check_month ($month)
	{
		$m = $month;
		settype ($m, "int");
		if ($m < 10)
		{
			settype ($m, "string");
			$m = "0".$m;
		}
		return $m;
	}
	
	function make_array (cc_calendar $cc_now)
	{
		$wday = $this->get_wday ($cc_now);
		if ($wday == 0)
			$wday = 7;
		$n =- ($wday - 2);
		for ($y = 0; $y < 6; $y++)
		{
			$row = array ();
			$notEmpty = false;
			for ($x = 0; $x < 7; $x++, $n++)
				if (@checkdate ($this->m, $n, $this->y))
				{
					$row[] = $n;
					$notEmpty = true;
				}
				else
					$row[] = "-";
			if (!$notEmpty) break;
			$this->month[] = $row;
		}
		return $this->month;
	}
	
	function make_table (cc_calendar $cc_now)
	{
		$str_m = $this->get_str_month ($cc_now);
		$e_month = $this->m - 1;
		$i_month = $this->m + 1;
		$e_year = $this->y;
		$i_year = $this->y;
		if ($e_month == 0)
		{
			$e_year--;
			$e_month = 12;
		}
		if ($i_month == 13)
		{
			$i_year++;
			$i_month = 1;
		}	
		$this->m = $this->check_month ($this->m);
		$i_month = $this->check_month ($i_month);
		$e_month = $this->check_month ($e_month);
		$this->table = "<table border='1' align='center' width='20%'><tr><td colspan='2' align='center'> <a href='admin.php?page=view&year=".$e_year."&month=".$e_month."'> <= </a> </td><td colspan='3' align='center'><a href='admin.php?page=view&year=".$this->y."&month=".$this->m."'>".$str_m."</a>, ".$this->y."</td><td colspan='2' align='center'> <a href='admin.php?page=view&year=".$i_year."&month=".$i_month."'> => </a> </td></tr>";
		$this->table .= "<tr><td align='center'></td><td align='center'></td><td align='center'></td><td align='center'></td><td align='center'></td><td align='center'></td><td align='center'>c</td></tr>";
		$this->month = $this->make_array ($cc_now);
		foreach ($this->month as $row)
		{
			$this->table .= "<tr>";
			foreach ($row as $i=>$v)
				if ($v != "-")
					$this->table .= "<td align='center'><a href='admin.php?page=view&year=".$this->y."&month=".$this->m."&day=".$v."'>".$v."</a></td>";
				else
					$this->table .= "<td align='center'>".$v."</td>";
			$this->table .= "</tr>";
		}
		$this->table .= "</table>";
		return $this->table;
	}
}