<?php
######################################################################
# CusCounter 3: Customer Counter
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: admin.php
# Version: 3.1.3
######################################################################

ini_set ("display_errors", 0);
ini_set ("session.use_trans_sid", true);

session_start ();

require_once ("../config/constants.php");
require_once ("../config/mysql.php");

require_once ("../class/cc_visit.php");
require_once ("../class/cc_db.php");
require_once ("../class/cc_error.php");
require_once ("../class/cc_ban.php");

if (!isset ($_SESSION['cc_if_login'])) 
	require_once ("../templates/admin/acces.php");
else 
{
	$cc_db = new cc_db (CC_DB_HOST, CC_DB_USER, CC_DB_PASS, CC_DB_NAME);
	$cc_error = new cc_error ();
	
	require_once ("../templates/admin/head.php");
	
	if (@opendir("../install"))
		require_once ("../templates/admin/install_no_delete.php");
	
	if (!isset ($_GET['page']))
		require_once ("../templates/admin/main.php");
	else
	{
		switch ($_GET['page'])
		{
			case "view": require_once ("view.php");
			break;
		
			case "settings": require_once ("settings.php");
			break;
		
			case "log": require_once ("log.php");	
			break;
		
			case "help": require_once ("../templates/admin/help.php");
			break;
		
			case "logout":
			{
				session_destroy ();
				require_once ("../templates/admin/logout.php");
			}
			break;
			
			case "ban": require_once ("ban.php");
			break;
			
			case "unban": require_once ("unban.php");
			break;
			
			case "banned": require_once ("banned.php");
			break;
			
			default: require_once ("../templates/admin/error.php");
		}
	}
	require_once ("../templates/admin/end.php");
	require_once ("../templates/admin/all.php");
}

?>