<?php
######################################################################
# MiniForum: Minimum Functionality Forum
# ============================================
# Copyright (c) 2007 by S.A.P.
# URL http://s-a-p.in/
# E-Mail developer@s-a-p.in
# ICQ 205618211
# JID s.a.p.@jabber.org
# ============================================
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
# File: post.php
# Version: 1.0
#####################################################################

class post
{
	private $id;
	private $status;
	private $text;
	private $create_date;
	private $create_ip;
	
	private $creator;
	private $theme;
	
	private $db;
	
	function __construct (&$db, $id = NULL) 
	{
		$this->db = $db;
		
		if ($id === NULL)
			return true;
		else 
			$this->id = $this->db->escape_string ($id);
			
		$this->db->sql_query ('SELECT * FROM `'._POSTS_TABLE.'` WHERE `id`="'.$this->id.'" LIMIT 1');
		$data = $this->db->fetchrow ();
		
		$this->status = $data['status'];
		$this->text = $data['text'];
		$this->create_date = $data['create_date'];
		$this->create_ip = $data['create_ip'];
		
		$this->creator = new user ($this->db, $data['creator']);
		
		$this->theme = new theme ($this->db, $data['theme']);
		
		return true;
	}
	
	public function get_id ()
	{
		return $this->id;
	}
	
	public function get ()
	{
		return array (
			'id' => $this->id,
			'text' => $this->text
		);
	}
	
	public function create ($text, $theme, $status, $creator, $create_date, $create_ip)
	{
		$this->text = $this->db->escape_string (htmlspecialchars ($text));
		$this->theme = new theme ($this->db, $theme);
		$this->creator = new user ($this->db, $creator);
		$this->status = $this->db->escape_string ($status);
		$this->create_date = $this->db->escape_string ($create_date);
		$this->create_ip = $this->db->escape_string ($create_ip);

		$this->db->sql_query ('INSERT INTO `'._POSTS_TABLE.'` (`status`, `text`, `create_date`, `create_ip`, `creator`, `theme`) VALUES ("'.$this->status.'", "'.$this->text.'", "'.$this->create_date.'", "'.$this->create_ip.'", "'.$this->creator->get_id().'", "'.$this->theme->get_id().'")');
		
		$this->id = $this->db->insert_id ();
		
		$this->db->sql_query ('UPDATE `'._THEMES_TABLE.'` SET `last_update`="'.$this->create_date.'" WHERE `id`="'.$this->theme->get_id().'" LIMIT 1');
		
		return $this->id;
	}
	
	public function delete ($type = _DELETE_TYPE)
	{
		if ($type == 0)
			$this->db->sql_query ('UPDATE `'._POSTS_TABLE.'` SET `status`=0 WHERE `id`="'.$this->id.'" LIMIT 1');
		else
			$this->db->sql_query ('DELETE FROM `'._POSTS_TABLE.'` WHERE `id`="'.$this->id.'" LIMIT 1');
		
		return true;
	}
	
	public function restore ()
	{
		$this->db->sql_query ('UPDATE `'._POSTS_TABLE.'` SET `status`=1 WHERE `id`="'.$this->id.'" LIMIT 1');
		return true;
	}
	
	public function edit_text ($text)
	{
		$this->text = $this->db->escape_string (htmlspecialchars ($text));
		$this->db->sql_query ('UPDATE `'._POSTS_TABLE.'` SET `text`="'.$this->text.'" WHERE `id`="'.$this->id.'" LIMIT 1');
		return $this->text;
	}
	
	public function check_theme ($theme)
	{
		$this->db->sql_query ('SELECT `status` FROM `'._THEMES_TABLE.'` WHERE `id`="'.$this->db->escape_string($theme).'" LIMIT 1');
		
		if (!$row = $this->db->fetchrow ())
			return 3;
			
		if ($row['status'] == 0)
			return 2;
			
		if ($row['status'] == 2)
			return 1;
			
		return 0;
	}
}

?>