<?php

error_reporting(-1);

function resizeFit($srcFile, $dstFile, $maxWidth, $maxHeight)
{
    if (!($size = @getimagesize($srcFile))) {
        throw new Exception('This is not image');
    }
    $type = $size['mime'];
    if ($type == 'image/pjpeg') {
        $type = 'image/jpeg';
    }
    $func = 'imagecreatefrom' . substr($type, 6);
    if( !function_exists($func)) {
        throw new Exception('Function ' . $func . ' is unavailable');
    }

    $oldImage = $func($srcFile);
    if( function_exists('exif_read_data')) {
        $angle = 0;
        $exif = exif_read_data($srcFile);
        $ort = isset($exif['Orientation']) ? $exif['Orientation'] : 
              (isset($exif['IFD0']['Orientation']) ? $exif['IFD0']['Orientation'] : 0);
        switch($ort) {
            case 3: 
                $angle = 180; break;
            case 5: case 6: case 7: 
                $angle = -90; break;
            case 8:
                $angle = 90; break;
        }
        if ($angle != 0) {
            $rotated = imagerotate($oldImage, $angle, 0);
            imagedestroy($oldImage);
            $oldImage = $rotated;
        }
    }
    $width  = imagesx($oldImage);
    $height = imagesy($oldImage);

    $ratio = max($width / $maxWidth, $height / $maxHeight);
    $newWidth = round($width / $ratio);
    $newHeight = round($height / $ratio);

    $newImage = imagecreatetruecolor($newWidth, $newHeight);
    imagecopyresampled($newImage, $oldImage, 0, 0, 0, 0, $newWidth, $newHeight, $width, $height); 
    imagedestroy($oldImage);
    imagejpeg($newImage, $dstFile, 80);
    imagedestroy($newImage);
}

resizeFit('./_DSC0812.JPG', './preview/_DSC0812.JPG', 500, 500);

header('Location: ' . './preview/_DSC0812.JPG');
