<?php
/**
 * Bicycle Libraries
 *
 * Set of libraries wich can help you
 *
 * @package   Bicycle Libraries
 * @author    Konstantin.Myakshin
 * @copyright Copyright (c) 2009-2010, Brouzie, Inc.
 * @license   LGPL
 * @link      http://brouzie.com/projects/bicycle-libraries/
 * @link      http://code.google.com/p/bicycle-libraries/
 * @filesource
 */

abstract class BL_Filesystem_AdapterAbstract
{
	protected $options = array();

	public function __construct(array $options)
	{
		$this->options = array_merge($this->options, $options);
		$this->connect();
		if (isset($this->options['dir']) && $this->options['dir'] && '.' != $this->options['dir']) {
			$this->cd($this->options['dir']);
		}
	}

	protected function connect()
	{
	}

	abstract public function read($path);

	abstract public function write($path, $data, $perms = 0666, $owerwrite = BL_Filesystem::OWERWRITE_ALL);

	abstract public function remove($path);

	abstract public function cd($dir);
}
