<?php
/**
 * Bicycle Libraries
 *
 * Set of libraries wich can help you
 *
 * @package   Bicycle Libraries
 * @author    Konstantin.Myakshin
 * @copyright Copyright (c) 2009-2010, Brouzie, Inc.
 * @license   LGPL
 * @link      http://brouzie.com/projects/bicycle-libraries/
 * @link      http://code.google.com/p/bicycle-libraries/
 * @filesource
 */

class BL_Filesystem_Adapter_Ftp extends BL_Filesystem_AdapterAbstract
{
	protected $conn;

	protected $options = array(
		'port'       => 21,
		'timeout'    => 30,
		'permsDir'   => 0755,
		'permsFiles' => 0644,
	);

	protected function connect()
	{
		$er = error_reporting(0);
		$this->conn = ftp_connect($this->options['host'], $this->options['port'], $this->options['timeout']);

		if ($this->conn) {
			$res = ftp_login($this->conn, $this->options['user'], $this->options['pass']);
		}
		error_reporting($er);

    if (!$this->conn || !$res) {
			$e = error_get_last();
			throw new BL_Filesystem_Exception($e['message']);
		}
	}

	public function cd($dir)
	{
		//TODO: rtrim?
		if (@ftp_chdir($this->conn, $dir)) {
			return true;
		}
		$e = error_get_last();
		throw new BL_Filesystem_Exception($e['message']);
	}

	public function mkDir($path, $perms = NULL, $recursive = true)
	{
		$path = rtrim($path, '/');
		NULL === $perms && $perms = $this->options['permsDir'];

		if ($this->dirExists($path)) {
			//TODO: set chmod?
			return true;
		}
		if (@ftp_mkdir($this->conn, $path)) {
			//TODO: set chmod
			return true;
		}
		if (!$recursive) {
			return false;
		}

		// recursive directory creation
		$dir = explode('/', $path);
		$dir[0] || $dir[0] = '/'; // path start from '/'

		$currentDir = ftp_pwd($this->conn);
//		var_dump('current dir', $currentDir);
		foreach ($dir as $_dir) {
			if (!$this->mkDir($_dir, $perms, false)) {
				// restore
				ftp_chdir($this->conn, $currentDir);
				throw new BL_Filesystem_Exception('Error on making directory');
			}
			ftp_chdir($this->conn, $_dir);
		}
		// restore
		ftp_chdir($this->conn, $currentDir);
//		$currentDir = ftp_pwd($this->conn);
//		var_dump('current dir', $currentDir);
		return true;
  }

	public function getConnection()
	{
		return $this->conn;
	}

	public function read($path)
	{
		//TODO: if file exists
		$tmpfile = tempnam('/tmp', 'cfs');
		ftp_get($this->conn, $tmpfile, $path, FTP_BINARY);
		$return = file_get_contents($tmpfile);
		unlink($tmpfile);

    return $return;
	}

	public function write($path, $data, $perms = NULL, $owerwrite = BL_Filesystem::OWERWRITE_ALL)
  {
		//TODO: convert perms
		NULL === $perms && $perms = $this->options['permsDir'];

		$tmpfile = tempnam('/tmp', 'cfs'); //TODO: use sys_get_temp_dir
		file_put_contents($tmpfile, $data);
		$path = $opath = rtrim($path, '/');

		$path = explode('/', $path);
		$path[0] || $path[0] = '/'; // path start from '/'
		if (count($path) > 1) {
			$file = array_pop($path);
			$dir = implode('/', $path);
			$this->mkDir($dir);
		}

		ftp_put($this->conn, $opath, $tmpfile, FTP_BINARY);
		//ftp_chmod($this->conn, $perms, $path);
		unlink($tmpfile);
		//TODO: check owerwrite
  }

	public function remove($path)
	{
		if ($this->fileExists($path)) {
			if (!@ftp_delete($this->conn, $path)) {
				$e = error_get_last();
				throw new BL_Filesystem_Exception($e['message']);
			}
		}
		return true;
	}

	public function listDir($path = '.')
	{
		if (!$this->dirExists($dir)) {
			throw new BL_Filesystem_Exception('Directory does not exists');
		}

		$lines = ftp_rawlist($this->conn, $path);
		$data = array();

		foreach ($lines as $line) {
			//TODO: win style too
			preg_match('/^([\-dl])([rwx\-]+)\s+(\d+)\s+(\w+)\s+(\w+)\s+(\d+)\s+(\w+\s+\d+\s+[\d\:]+)\s+(.*)$/', $line, $matches);
			list($trash, $type, $permissions, $unknown, $owner, $group, $bytes, $date, $name) = $matches;

			if ('l' != $type) {
				$data[] = array(
					'name'        => $name,
					'type'        => $type,
					'permissions' => $permissions,
					'bytes'       => $bytes,
					'date'        => $date
				);
			}
		}
		//TODO: use collection of files
		return $data;
	}

	public function dirExists($dir)
	{
		$currentDir = ftp_pwd($this->conn);
		$dir = explode('/', rtrim($dir, '/'));
		$dir[0] || $dir[0] = '/'; // path start from '/'

		$ret = true;
		foreach ($dir as $_dir) {
			if (!@ftp_chdir($this->conn, $_dir)) {
				$ret = false;
				break;
			}
		}
		// restore
		ftp_chdir($this->conn, $currentDir);
		return $ret;
	}

	public function fileExists($path)
	{
		//TODO: use listDir
		return -1 !== @ftp_size($this->conn, $path);
	}
}
