<?php
/**
 * Bicycle Libraries
 *
 * Set of libraries wich can help you
 *
 * @package   Bicycle Libraries
 * @author    Konstantin.Myakshin
 * @copyright Copyright (c) 2009-2010, Brouzie, Inc.
 * @license   LGPL
 * @link      http://brouzie.com/projects/bicycle-libraries/
 * @link      http://code.google.com/p/bicycle-libraries/
 * @filesource
 */

class BL_Filesystem
{
	const OWERWRITE_NONE = 0;
	const OWERWRITE_NEW  = 1;
	const OWERWRITE_ALL  = 2;

	/**
	 * @var BL_Filesystem_AdapterAbstract
	 */
	protected $adapter;

	/**
	 *
	 * @param string|BL_Filesystem_AdapterAbstract $adapter
	 * @param array $options
	 */
	public function __construct($adapter = 'ftp', array $options = array())
	{
		if (is_string($adapter)) {
			$adapter = 'BL_Filesystem_Adapter_' . ucfirst($adapter);
			$adapter = new $adapter($options);
		}

		if (!in_array('BL_Filesystem_AdapterAbstract', class_parents($adapter))) {
			throw new InvalidArgumentException('Wait for child of BL_Filesystem_AdapterAbstract');
		}

		$this->adapter = $adapter;
	}

	/**
	 *
	 * @param string|BL_Filesystem_AdapterAbstract $adapter
	 * @param array $options
	 * @return BL_Filesystem
	 */
	public static function init($adapter = 'ftp', array $options = array())
	{
		return new self($adapter, $options);
	}

	/**
	 *
	 * @return BL_Filesystem_AdapterAbstract
	 */
	public function getAdapter()
	{
		return $this->adapter;
	}

	public function read($path)
	{
		return $this->adapter->read($path);
	}

	public function write($path, $data, $perms = 0666, $owerwrite = BL_Filesystem::OWERWRITE_ALL)
	{
		return $this->adapter->write($path, $data, $perms);
	}

	public function remove($path)
	{
		return $this->adapter->remove($path);
	}

	public function __call($name, $arguments)
	{
		return call_user_func_array(array($this->adapter, $name), $arguments);
	}
}
