<?php
/**
 * Bicycle Libraries
 *
 * Set of libraries wich can help you
 *
 * @package   Bicycle Libraries
 * @author    Konstantin.Myakshin
 * @copyright Copyright (c) 2009-2010, Brouzie, Inc.
 * @license   LGPL
 * @link      http://brouzie.com/projects/bicycle-libraries/
 * @link      http://code.google.com/p/bicycle-libraries/
 * @filesource
 */

abstract class BL_Deploy_ChangesAbstract
{
	/**
	 *
	 * @param int|string $revFrom
	 * @param int|string|NULL $revTo
	 * @return array array('upload' => array('file1', 'file2'), 'remove' => array('file3', 'file4'))
	 */
	abstract public function getChanges($revFrom, $revTo = NULL);

	abstract public function getRevision();

	/**
	 * @param string $path
	 * @param string $rev
	 */
	abstract public function export($path, $rev = NULL);

	protected function fixPath($path)
	{
		return DIRECTORY_SEPARATOR == '\\' ? str_replace('\\', '/', $path) : $path;
	}
}
