<?php
/**
 * Bicycle Libraries
 *
 * Set of libraries wich can help you
 *
 * @package   Bicycle Libraries
 * @author    Konstantin.Myakshin
 * @copyright Copyright (c) 2009-2010, Brouzie, Inc.
 * @license   LGPL
 * @link      http://brouzie.com/projects/bicycle-libraries/
 * @link      http://code.google.com/p/bicycle-libraries/
 * @filesource
 */

class BL_Deploy_Changes_Mercurial extends BL_Deploy_ChangesAbstract
{
	public function getChanges($revFrom, $revTo = NULL)
	{
		$command = $revTo ? sprintf('hg status --rev %s:%s', $revFrom, $revTo) : sprintf('hg status --rev %s', $revFrom);
		
		$output = array();
		$status = exec($command, $output);
		$filesToRemove = $filesToUpload = array();

		foreach ($output as $file) {
			list($action, $file) = explode(' ', $file, 2);

			switch ($action) {
				case 'R':
					$filesToRemove[] = $this->fixPath($file);
					break;
				//TODO: another actions (copy/move)?
				case 'A':
				case 'M':
					$filesToUpload[] = $this->fixPath($file);
					break;
			}
		}

		return array('upload' => $filesToUpload, 'remove' => $filesToRemove);
	}

	public function getRevision()
	{
		$command = 'hg log -l 1 --template "{rev}"';
		$output = array();
		$status = exec($command, $output);
		return $output[0];
	}

	public function export($path, $rev = NULL)
	{
		$rev || $rev = $this->getRevision();

		$command = 'hg archive -r %d %s';
		$command = sprintf($command, $rev, $path);
		//$output = array();
		$status = exec($command, $output);
		//return $output[0];
	}
}
