<?php

// relative to this file
define('BL_REPOSITORY_DIR', '../');
// relative to repo
define('BL_CORE_DIR', 'code/core/');
// relative to repo. Move out this file from repo visibility
define('BL_DEPLOY_CONFIG', 'config/deploy.php');

error_reporting(-1);
set_time_limit(0);
ini_set('display_errors', 1);
ini_set('log_errors', 0);
ini_set('html_errors', 0);

#######################################
#### DO NOT EDIT BELOW THESE LINES ####
#######################################

chdir(BL_REPOSITORY_DIR);
set_include_path(realpath(getcwd()) . PATH_SEPARATOR . realpath('code/vendors'));

function autoloadBL($className)
{
	// core libraries
	if ('BL_' == substr($className, 0, 3)) {
		$file = BL_CORE_DIR . str_replace('_', '/', substr($className, 3)) . '.php';
		if (file_exists($file)) {
			include_once $file;
			return true;
		} else {
			throw new BL_Exception(sprintf('Missing core file "%s" for class "%s"', $file, $className));
		}
	}
}

spl_autoload_register('autoloadBL');

$deploy = new BL_Deploy(include BL_DEPLOY_CONFIG);
$deploy->run();
