<?php

class View
{
    private
        $_parents = array(),
        $_names   = array(),
        $_blocks  = array();

    public function render($id, $data)
    {
        extract($data);
        $this->_prepare($id);
        include 'templates/' . $id . '.php';
        while (!empty($this->_parents)) {
            $this->_grab('content');
            extract($this->_blocks);
	        $this->_prepare($id = array_pop($this->_parents));
            include 'templates/' . $id . '.php';
        }
    }

	protected function _prepare($id)
	{
	}

    private function _extend($id)
    {
        array_push($this->_parents, $id);
        ob_start();
    }

    private function _blockBegin($block)
    {
        array_push($this->_names, $block);
        ob_start();
    }

    private function _blockEnd()
    {
        $this->_grab(array_pop($this->_names));
    }

    private function _grab($block)
    {
        if (isset($this->_blocks[$block])) {
            ob_end_clean();
            return;
        }
        $tmp = ob_get_clean();
        if (strlen(trim($tmp)) > 0) {
            $this->_blocks[$block] = $tmp;
        }
    }
}
