<?php

require 'view.php';

class CompileView extends View
{
	private
		$_rules = array(
			'#^(\$.*)$#'			=> 'echo $1; ',
			'#^@(\$.*)$#'			=> 'echo htmlspecialchars($1, ENT_QUOTES); ',

			'#^extend\s+(.*)$#'		=> '$this->_extend($1); ',

			'#^block\s+(.*)$#'		=> '$this->_blockBegin($1); ',
			'#^/block$#'			=> '$this->_blockEnd(); ',

			'#^if\s+(.*)$#'			=> 'if (!empty($1)): ',
			'#^elseif\s+(.*)$#'		=> 'elseif (!empty($1)): ',
			'#^else$#'				=> 'else: ',
			'#^/if$#'				=> 'endif; ',

			'#^for\s+([^,]+)\s+in\s+(.*)$#'			=> 'foreach ($2 as $1): ',
			'#^for\s+([^,]+),([^,]+)\s+in\s+(.*)$#'	=> 'foreach ($3 as $1 => $2): ',
			'#^/for$#'								=> 'endforeach; ',
		);

	protected function _prepare($id)
	{
		$template = 'templates/' . $id . '.tpl.html';
		$compiled = 'templates/' . $id . '.php';

		if (!file_exists($template)) {
			throw new Exception('Template "' . $template . '" not found');
		}
		$timeT = filemtime($template);
		$timeC = file_exists($compiled) ? filemtime($compiled) : 0;

		// Compiled version is absent or obsolete
		if ($timeC < $timeT)
		{
			// Get template and find parts looks like "{macro}"
			$text = str_replace(array('<?', '?>'), array('&lt;?', '?&gt;'), file_get_contents($template));
			$parts = preg_split('/(\{.*\})/U', $text, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);

			$text = '';
			$wasPhp = FALSE;
			foreach ($parts as $part) {
				$isPhp = FALSE;
				if ($part{0} == '{' && $part{strlen($part) - 1} == '}') {
					$macro = substr($part, 1, -1);
					foreach ($this->_rules as $pattern => $replace) {
						if (preg_match($pattern, $macro)) {
							$part = preg_replace($pattern, $replace, $macro);
							$isPhp = TRUE;
							break;
						}
					}
				}
				if ($isPhp != $wasPhp) {
					if ($wasPhp) $text .= '?>';
					if ($isPhp)  $text .= '<?php ';
				}
				$wasPhp = $isPhp;
				$text .= $part;
			}

			file_put_contents($compiled, $text);
		}
	}
}