<?php

error_reporting(-1);

class MyView
{
    private
        $_parents = array(),
        $_names   = array(),
        $_blocks  = array();

    public function render($id, $data)
    {
        extract($data);
        include 'templates/' . $id . '.php';
        while (!empty($this->_parents)) {
            $this->_grab('content');
            include 'templates/' . array_pop($this->_parents) . '.php';
        }
    }

    private function extend($id)
    {
        array_push($this->_parents, $id);
        ob_start();
    }

    private function blockBegin($block)
    {
        array_push($this->_names, $block);
        ob_start();
    }

    private function blockEnd()
    {
        $this->_grab(array_pop($this->_names));
    }

    private function output($block, $default = '')
    {
        echo (isset($this->_blocks[$block])) ?
            $this->_blocks[$block] :
            $default;
    }

    private function _grab($block)
    {
        if (isset($this->_blocks[$block])) {
            ob_end_clean();
            return;
        }
        $tmp = ob_get_clean();
        if (strlen(trim($tmp)) > 0) {
            $this->_blocks[$block] = $tmp;
        }
    }
}

// ----- Test

$view = new MyView();

$view->render('test', array('title' => 'Blablabla', 'text' => 'The wind has blown over ther ocean'));
