<?php

class Qb
{
    private static
    	$_registry   = array(),
    	$_components = array(),
    	$_classes    = array(),
    	$_events     = array(),
    	$_sysDir     = './';

	public static function init($config = NULL)
	{
		self::$_sysDir = dirname(__FILE__) . '/';

		if (is_null($config)) {
			$config = self::$_sysDir . '../config/main.php';
		}

		$reg =& self::$_registry;
		$reg = is_array($config) ? $config : include($config);

		self::$_components = isset($reg['components']) ? $reg['components'] : array();
		self::$_classes    = isset($reg['classes'])    ? $reg['classes']    : array();
		self::$_events     = isset($reg['events'])     ? $reg['events']     : array();
		unset($reg['components']);
		unset($reg['classes']);
		unset($reg['events']);

		spl_autoload_register('QB::_classHandler');
	}

	private static function _classHandler($className)
	{
		$fileName = isset(self::$_classes[$className]) ? self::$_classes[$className] : $className;
		@include self::$_sysDir . strtolower($fileName).'.php';
	}

	public static function get($alias, $default = NULL)
	{
		// Try to find tree node for this alias
		$ref =& self::$_registry;
		foreach (explode('.', $alias) as $name) {
			if (isset($ref[$name])) {
				$ref =& $ref[$name];
			} else {
				unset($ref);
				break;
			}
		}

		if (!isset($ref) && isset(self::$_components[$alias])) {
			$args = self::$_components[$alias];
			$class = array_shift($args);
			self::set($alias, $ref = new $class($args));
		}

		return isset($ref) ? $ref : $default;
	}

	public static function set($alias, $value)
	{
		$ref =& self::$_registry;
		foreach (explode('.', $alias) as $name) {
			if (!isset($ref[$name])) $ref[$name] = NULL;
			$ref =& $ref[$name];
		}
		$ref = $value;
	}

	// Debug only!
/*	public static function _dump()
	{
		return
			'Registry: '.var_export(self::$_registry, TRUE) ."\n" .
			'Components: '.var_export(self::$_components, TRUE) ."\n" .
			'Classes: '.var_export(self::$_classes, TRUE) ."\n" .
			'Events: '.var_export(self::$_events, TRUE);
	} */

	public static function attachEventHandler($name, $handler)
	{
		$e =& self::$_events;
		// Do not attach the same handler twice!
		if (!isset($e[$name]) || array_search($handler, $e[$name]) === FALSE) {
			$e[$name][] = $handler;
		}
	}

	public static function detachEventHandler($name, $handler)
	{
		$e =& self::$_events;
		if (isset($e[$name]) && ($key = array_search($handler, $e[$name])) !== FALSE) {
				unset($e[$name][$key]);
		}
	}

	public static function raiseEvent($name, $event = NULL)
	{
		// Event handlers should return not empty value on success
		$result = FALSE;

		$e =& self::$_events;
		if (isset($e[$name])) {
			foreach ($e[$name] as $handler) {
				// Is handler defined via "object alias"
				if (is_array($handler) && is_string($handler[0]) && isset(self::$_components[$handler[0]])) {
					$handler[0] = self::get($handler[0]);
				}
				$result = call_user_func($handler, $event) || $result;
			}
		}

		return $result;
	}

}


abstract class QbCustomComponent
{
	public function __construct($args)
	{
		if (!empty($args)) {
			//  Map arguments to component properties
			foreach ($args as $key => $value) {
				$this->$key = $value;
			}
		}
	}
}

