<?php

error_reporting(-1);
ini_set('display_errors', 1);

require './lib/qb.php';

// Read configuration & set handlers
Qb::init();

header('Content-type: text/plain');

// Get "simple" value
echo 'A=' . Qb::get('some.parameters.A') . "\n";
echo 'B=' . Qb::get('some.parameters.B') . "\n";
echo 'C=' . Qb::get('some.parameters.C') . "\n"; // NULL
// Get "subtree"
echo 'some.parameters=' . var_export(Qb::get('some.parameters'), TRUE) . "\n";


// Get components
$db   = Qb::get('db');
$obj  = Qb::get('another.obj');
$more = Qb::get('just.another.one.obj'); // NULL

//  and test it
echo 'query=' . $db->query('SELECT * FROM :p_topics') . "\n";
echo 'obj->caption=' . $obj->caption."\n";
echo 'more=' . var_export($more, TRUE) . "\n";

// Get "secret" value. It is component init parameter.
//echo Qb::get('components.db.password') . "\n"; // ERROR

// Dump our registry
//echo "\nRegistry dump:\n".Qb::_dump()."\n";