<?php

error_reporting(-1);
ini_set('display_errors', 1);

require './lib/qb.php';

// Read configuration & set handlers
Qb::init();

class ClassA
{
	public static function myHandler1()
	{
		echo "A handler1\n";
		return TRUE;
	}

	public static function myHandler2()
	{
		echo "A handler2\n";
		return TRUE;
	}
}

class ClassB
{
	public function myHandler1()
	{
		echo "B handler1\n";
		return TRUE;
	}
}

function cHandler()
{
	echo "C handler\n";
	return TRUE;
}

header('Content-type: text/plain');

$b = new ClassB();

// Set event handlers
Qb::attachEventHandler('onBeep', array('ClassA', 'myHandler1'));
Qb::attachEventHandler('onBeep', array($b, 'myHandler1'));
Qb::attachEventHandler('onSleep', array('ClassA', 'myHandler2')); // already attached in config file
Qb::attachEventHandler('onSleep', 'cHandler');

// Remove some handlers
//Qb::detachEventHandler('onBeep', array('ClassA', 'myHandler1'));
//Qb::detachEventHandler('onBeep', array($b, 'myHandler1'));
//Qb::detachEventHandler('onSleep', 'cHandler');

// Raise events
echo "Beep:\n";
Qb::raiseEvent('onBeep');
echo "Sleep:\n";
Qb::raiseEvent('onSleep');

/* echo "\n" . Qb::_dump(); */