<?php

class Qb
{
    private static
    	$_registry	= array(),
    	$_sysDir	= './';

	public static function init($config = NULL)
	{
		self::$_sysDir = dirname(__FILE__) . '/';

		if (is_null($config)) {
			$config = self::$_sysDir . '../config/main.php';
		}

		if (is_array($config)) {
			self::$_registry = $config;
		} else {
			self::$_registry = include($config);
		}

		spl_autoload_register('QB::_classHandler');
	}

	private static function _classHandler($className)
	{
		@include self::$_sysDir . strtolower($className).'.php';
	}

	public static function get($alias, $default = NULL)
	{
		if (strpos($alias, 'components.') === 0)
			throw new Exception('Atempt to hack!');

		// Try to find tree node for this alias
		$ref =& self::$_registry;
		foreach (explode('.', $alias) as $name) {
			if (isset($ref[$name])) {
				$ref =& $ref[$name];
			} else {
				// Not found
				unset($ref);
				break;
			}
		}

		if (!isset($ref) && isset(self::$_registry['components'][$alias])) {
			$args = self::$_registry['components'][$alias];
			$class = array_shift($args);
			self::set($alias, $ref = new $class($args));
		}

		return isset($ref) ? $ref : $default;
	}

	public static function set($alias, $value)
	{
		if (strpos($alias, 'components.') === 0)
			throw new Exception('Atempt to hack!');

		$ref =& self::$_registry;
		foreach (explode('.', $alias) as $name) {
			if (!isset($ref[$name])) $ref[$name] = NULL;
			$ref =& $ref[$name];
		}
		$ref = $value;
	}

	// Debug only!
/*	public static function _dump()
	{
		return var_export(self::$_registry, TRUE);
	} */
}


abstract class QbCustomComponent
{
	public function __construct($args)
	{
		if (!empty($args)) {
			//  Map arguments to component properties
			foreach ($args as $key => $value) {
				$this->$key = $value;
			}
		}
	}
}

