<?php

class Qb
{
    private static
    	$_config	= array(),
    	$_instances	= array(),
    	$_sysDir		= './';

	public static function init($config = NULL)
	{
		self::$_sysDir = dirname(__FILE__) . '/';

		if (is_null($config)) {
			$config = self::$_sysDir . '../config/main.php';
		}

		if (is_array($config)) {
			self::$_config = $config;
		} else {
			self::$_config = include($config);
		}

		spl_autoload_register('QB::_classHandler');
	}

	private static function _classHandler($className)
	{
		require self::$_sysDir . strtolower($className).'.php';
	}

	public static function get($alias, $default = NULL)
	{
		$ref =& self::$_config;
		foreach (explode('.', $alias) as $name){
			if (isset($ref[$name])) {
				$ref =& $ref[$name];
			} else {
				return $default;
			}
		}
		return $ref;
	}

	private static function _grab($alias, $default = NULL)
	{
		$ref =& self::$_config;
		foreach (explode('.', $alias) as $name) {
			if (isset($ref[$name])) {
				$prev =& $ref;
				$ref =& $ref[$name];
			}
			else {
				return $default;
			}
		}

		$value = $ref;
		unset($prev[$name]);
		return $value;
	}

    public static function load($key)
    {
		if (!isset(self::$_instances[$key])) {
			$class = self::get('classMap.' . $key, $key);
			$args = self::_grab($key);
			self::$_instances[$key] = new $class($args);
		}
		return self::$_instances[$key];
    }
}

abstract class QbCustomComponent
{
	public function __construct($args)
	{
		if (!empty($args)) {
			foreach ($args as $key => $value) {
				$this->$key = $value;
			}
		}
	}
}

