<?php

//
// Application super-class. Stores configuration.
//
class Qb
{
	public static
		$config,
		$configDir;

	public static function init($cfg)
	{
		if (!file_exists($cfg))
			exit('Not configured. Run install.php first!');

		self::$config = include($cfg);
		self::$configDir = dirname($cfg).'/';
	}
}


//
// Two-way request router. Binary search version.
//
class Router
{
	private static
		$_routes,
		$_items,
		$_vars;

	public static function request()
	{
		$tmp = parse_url(urldecode('http://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']));
		$request = substr($tmp['path'], strlen(Qb::$config['prefix']));
		// Sort query parameters if any
		if (isset($tmp['query']))
		{
			$tmp = explode('&', $tmp['query']);
			sort($tmp);
			$request .= '?' . implode('&', $tmp);
		}
		return $request;
	}

	public static function route($request)
	{
		self::_prepare();

		self::$_vars = array();
		$items =& self::$_items;

		// Binary search
		$imin = 0;
		$imax = count($items) - 1;
		$found = FALSE;
		while ($imin <= $imax)
		{
			$i = ($imin + $imax) >> 1;

            $res = strcmp($quick = $items[$i][1], substr($request, 0, strlen($quick)));
			if ($res == 0)
			{
				// We've found something good, but we aren't sure it's the first good item!
				// Iterate descending
				for ($j = $i - 1; $j > $imin; $i = $j--)
				{
					list($key, $quick, $pattern, $names) = $items[$j];
					if (substr($request, 0, strlen($quick)) != $quick)
						break;
					if ($found = preg_match($pattern, $request, $matches))
						break 2; // out while
				}
				// Iterate ascending
				for (; $i <= $imax; ++$i)
				{
					list($key, $quick, $pattern, $names) = $items[$i];
					if (substr($request, 0, strlen($quick)) != $quick)
						break 2; // out while
					if ($found = preg_match($pattern, $request, $matches))
						break 2; // out while
				}
				break;
			}
			else if ($res > 0)
				$imax = $i - 1;
			else
				$imin = $i + 1;
		} // while

		if (!$found)
			return FALSE;

		for ($k = 1, $n = count($matches); $k < $n; ++$k)
			self::$_vars[$names[$k-1]] = $matches[$k];
		return $key;

	}

	public static function getVars()
	{
		return self::$_vars;
	}

	public static function url($key, $vars = NULL)
	{
		self::_prepare();

		if (is_null($vars))
			return Qb::$config['baseUrl'].self::$_routes[$key];
		else
		{
			$url = self::$_routes[$key];
			foreach ($vars as $id => $value)
				$url = str_replace('{$'.$id.'}', $value, $url);
			return Qb::$config['baseUrl'].$url;
		}
	}

	private static function _prepare()
	{
		if (!is_null(self::$_routes))
			return;

		$raw = Qb::$configDir.'routes.php';
		$compiled = Qb::$config['cacheDir'].'routes.dat';

		if (file_exists($compiled) && filemtime($compiled) > filemtime($raw))
		{
			list(self::$_routes, self::$_items) = unserialize(file_get_contents($compiled));
			return;
		}

		self::$_routes = include($raw);
		self::$_items = array();
		foreach (self::$_routes as $key => &$route)
		{
			// Sort query parameters if any
			if (($p = strpos($route, '?')) !== FALSE)
			{
				$tmp = explode('&', substr($route, $p+1));
				sort($tmp);
				$route = substr($route, 0, $p+1) . implode('&', $tmp);
			}

			// Has the route string any parameter?
			if (($p = strpos($route, '{$')) === FALSE)
			{
				// No, it hasn't
				$quick = $route;
				$pattern = '|^'.preg_quote($route, '|').'$|';
				$names = NULL;
			}
			else
			{
				// Yes, it has. Save heading substring
				$quick = substr($route, 0, $p);
				$pattern = '';
				$names = array();
				// Process variable parts
				foreach (preg_split('|({\$.+})|U', $route, -1, PREG_SPLIT_DELIM_CAPTURE|PREG_SPLIT_NO_EMPTY) as $part)
				{
					if (substr($part, 0, 2) == '{$')
					{
						$names[] = $name = substr($part, 2, -1);
						if ($name == 'page' || substr($name, -2) == 'id')
							$pattern .= '(\d+)';
						else if (substr($name, -4) == 'date')
							$pattern .= '([0-9\-]+)';
						else
							$pattern .= '(.+)';
					}
					else
						$pattern .= preg_quote($part, '|');
				}
				$pattern = '|^'.$pattern.'$|';
			}

			self::$_items[] = array($key, $quick, $pattern, $names);
		} // foreach routes

		usort(self::$_items, array('self', '_sortByQuick')); // REQUIRED !
		file_put_contents($compiled, serialize(array(self::$_routes, self::$_items)));
	}

	private static function _sortByQuick($a, $b)
	{
		return strcmp($a[1], $b[1]);
	}
}


//
// Tests
//
Qb::init('./config/main.php');

header('Content-type: text/plain');

//echo 'url(topic.view.p) = '.Router::url('topic.view.p', array('tid'=>10, 'page'=>2))."\n\n";

$request = Router::request();
echo 'request = "'.$request."\"\n\n";

$route = Router::route($request);
echo 'route = '.$route."\n\n";
if ($route !== FALSE)
{
	echo "Variables:\n";
	print_r(Router::getVars());
}

