<?php

if (file_exists('./config/main.php'))
{
	echo 'Already installed';
	exit();
}

$prefix = str_replace('\\', '/', dirname($_SERVER['REQUEST_URI']));
if ($prefix != '/') $prefix .= '/';
$baseUrl = 'http://' . $_SERVER['SERVER_NAME'] . $prefix;
$baseDir = str_replace('\\', '/', dirname($_SERVER['SCRIPT_FILENAME'])) . '/';

$config = array(
'cacheDir'	=> $baseDir.'cache/',
'sysDir'	=> $baseDir.'sys/',
'webDir'	=> $baseDir,
'baseUrl'	=> $baseUrl,
'prefix'	=> $prefix,
);

function generateConfig($config)
{
	return "<?php\n\nreturn ".var_export($config, TRUE).";\n";
}

if (isset($_POST['form_sent']))
{
	// Attempt to write config.php and serve it up for download if writing fails
	$written = false;
	if (is_writable('./'))
	{
		$fh = @fopen('./config/main.php', 'wb');
		if ($fh)
		{
			fwrite($fh, generateConfig($config));
			fclose($fh);

			$written = true;
		}
	}
	if ($written)
		echo 'Configuration saved.';
	else
		echo 'Unable to write file. Please go back to copy text and create file manually.';
}
else
{
	echo "<h3>Your new config file:</h3>\n";
	echo "<pre>\n".htmlspecialchars(generateConfig($config))."</pre>\n";
	echo <<<T
<form action="install.php" method="post">
	<input type="hidden" name="form_sent" />
	<button type="submit">Save configuration</button>
</form>
T;
}